/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc.mysql;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.wildfly.common.Assert;

@QuarkusTest
@DisabledIfSystemProperty(named="cq.jdbcKind", matches="derby")
public class CamelMysqlJdbcTest {
    String dbKind = "mysql";

    @Test
    void testGetSpeciesById() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/" + this.dbKind + "/species/1", new Object[0])).then()).body(Matchers.equalToIgnoringCase((String)"[{SPECIES=Camelus dromedarius}]"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/" + this.dbKind + "/species/2", new Object[0])).then()).body(Matchers.equalToIgnoringCase((String)"[{SPECIES=Camelus bactrianus}]"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/" + this.dbKind + "/species/3", new Object[0])).then()).body(Matchers.equalToIgnoringCase((String)"[{SPECIES=Camelus ferus}]"), new Matcher[0]);
    }

    @Test
    void testGetSpeciesByIdWithResultList() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/" + this.dbKind + "/species/1/list", new Object[0])).then()).body(Matchers.is((Object)"Camelus dromedarius 1"), new Matcher[0]);
    }

    @Test
    void testGetSpeciesByIdWithDefinedType() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/" + this.dbKind + "/species/1/type", new Object[0])).then()).body(Matchers.equalToIgnoringCase((String)"Camelus dromedarius 1"), new Matcher[0]);
    }

    @Test
    void testExecuteStatement() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select id from camels order by id desc").post("/test/" + this.dbKind + "/execute", new Object[0])).then()).body(Matchers.equalToIgnoringCase((String)"[{ID=3}, {ID=2}, {ID=1}]"), new Matcher[0]);
    }

    @Test
    void testCamelRetrieveGeneratedKeysHeader() {
        String idKey = "GENERATED_KEY";
        List generatedIDs = ((ValidatableResponse)((Response)RestAssured.given().get("test/" + this.dbKind + "/generated-keys/rows", new Object[0])).then()).extract().body().jsonPath().getList(idKey);
        Assert.assertFalse((boolean)generatedIDs.isEmpty());
        Assert.assertNotNull(generatedIDs.get(0));
    }

    @Test
    void testHeadersFromInsertOrUpdateQuery() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("test/" + this.dbKind + "/headers/insert", new Object[0])).then()).body(Matchers.containsStringIgnoringCase((String)"CamelGeneratedKeysRowCount=1"), new Matcher[0])).and()).body(Matchers.containsStringIgnoringCase((String)"CamelJdbcUpdateCount=1"), new Matcher[0])).and()).body(Matchers.containsStringIgnoringCase((String)"CamelRetrieveGeneratedKeys=true"), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelJdbcRowCount")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelJdbcColumnNames")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelJdbcParameters")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelGeneratedColumns")), new Matcher[0]);
    }

    @Test
    void testHeadersFromSelectQuery() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("test/" + this.dbKind + "/headers/select", new Object[0])).then()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelGeneratedKeysRowCount")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelJdbcUpdateCount")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelRetrieveGeneratedKeys")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelJdbcParameters")), new Matcher[0])).and()).body(Matchers.not((Matcher)Matchers.containsStringIgnoringCase((String)"CamelGeneratedColumns")), new Matcher[0])).and()).body(Matchers.containsStringIgnoringCase((String)"CamelJdbcRowCount"), new Matcher[0])).and()).body(Matchers.containsStringIgnoringCase((String)"CamelJdbcColumnNames=[ID, SPECIES]"), new Matcher[0]);
    }

    @Test
    void testNamedParameters() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("test/" + this.dbKind + "/named-parameters/headers-as-parameters", new Object[0])).then()).body(Matchers.containsStringIgnoringCase((String)"{ID=1, SPECIES=Camelus dromedarius}"), new Matcher[0])).and()).body(Matchers.containsStringIgnoringCase((String)"{ID=2, SPECIES=Camelus bactrianus}"), new Matcher[0]);
    }

    @Test
    void testCamelJdbcParametersHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().get("test/" + this.dbKind + "/named-parameters/headers-as-parameters-map", new Object[0])).then()).body(Matchers.containsStringIgnoringCase((String)"{ID=2, SPECIES=Camelus bactrianus}"), new Matcher[0]);
    }

    @Test
    void testTimeIntervalDatabasePolling() {
        String selectResult = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select * from camelsGenerated order by id desc").post("/test/" + this.dbKind + "/execute", new Object[0])).then()).extract().body().asString();
        ((ValidatableResponse)((Response)RestAssured.given().body(selectResult).get("/test/" + this.dbKind + "/interval-polling", new Object[0])).then()).statusCode(204);
    }

    @Test
    void testMoveDataBetweenDatasources() {
        String camelsDbResult = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select * from camels order by id desc").post("/test/" + this.dbKind + "/execute", new Object[0])).then()).extract().body().asString();
        RestAssured.given().post("test/" + this.dbKind + "/move-between-datasources", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("select * from camelsProcessed order by id desc").post("/test/" + this.dbKind + "/execute", new Object[0])).then()).body(Matchers.equalTo((Object)camelsDbResult), new Matcher[0]);
    }
}

