/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.http;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.builder.endpoint.dsl.DirectEndpointBuilderFactory;
import org.apache.camel.builder.endpoint.dsl.HttpEndpointBuilderFactory;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.http.common.AbstractHttpResource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/test/client/http")
@ApplicationScoped
public class HttpResource
extends AbstractHttpResource {
    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String httpGet(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.toF("http://localhost:%d/service/common/get?bridgeEndpoint=true&connectTimeout=2000", new Object[]{port}).withHeader("CamelHttpMethod", (Object)"GET").request(String.class);
    }

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String httpPost(@QueryParam(value="test-port") int port, String message) {
        return (String)this.producerTemplate.toF("http://localhost:%d/service/common/toUpper?bridgeEndpoint=true", new Object[]{port}).withBody((Object)message).withHeader("Content-Type", (Object)"text/plain").withHeader("CamelHttpMethod", (Object)"POST").request(String.class);
    }

    @Path(value="/auth/basic")
    @GET
    @Produces(value={"text/plain"})
    public Response basicAuth(@QueryParam(value="test-port") int port, @QueryParam(value="username") String username, @QueryParam(value="password") String password) {
        Exchange result = this.producerTemplate.withHeader("CamelHttpQuery", (Object)"component=http").toF("http://localhost:%d/test/client/http/auth/basic/secured?throwExceptionOnFailure=false&authMethod=BASIC&authUsername=%s&authPassword=%s", new Object[]{port, username, password}).send();
        Integer status = (Integer)result.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        String body = (String)result.getMessage().getBody(String.class);
        return Response.status((int)status).entity((Object)body).build();
    }

    @Path(value="/auth/basic/cache")
    @GET
    @Produces(value={"text/plain"})
    public Response httpBasicAuthCache(@QueryParam(value="test-port") int port) {
        Exchange result = this.producerTemplate.withHeader("CamelHttpQuery", (Object)"component=http").toF("http://localhost:%d/test/client/http/auth/basic/secured?throwExceptionOnFailure=false&httpContext=#basicAuthContext", new Object[]{port}).send();
        Integer status = (Integer)result.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        String body = (String)result.getMessage().getBody(String.class);
        return Response.status((int)status).entity((Object)body).build();
    }

    @Path(value="/proxy")
    @GET
    @Produces(value={"application/xml"})
    public String httpProxy() {
        Config config = ConfigProvider.getConfig();
        String proxyHost = (String)config.getValue("proxy.host", String.class);
        Integer proxyPort = (Integer)config.getValue("proxy.port", Integer.class);
        return (String)this.producerTemplate.toF("%s?proxyAuthMethod=Basic&proxyAuthScheme=http&proxyAuthHost=%s&proxyAuthPort=%d&proxyAuthUsername=%s&proxyAuthPassword=%s", new Object[]{String.format("https://repo.maven.apache.org/maven2/org/apache/camel/quarkus/camel-quarkus-%s/maven-metadata.xml", "http"), proxyHost, proxyPort, "admin", "adm1n"}).request(String.class);
    }

    @Path(value="/send-dynamic")
    @GET
    @Produces(value={"application/json"})
    public String getSendDynamic(@QueryParam(value="test-port") int port) {
        return (String)this.producerTemplate.withHeader("SendDynamicHttpEndpointPort", (Object)port).to("direct:send-dynamic").request(String.class);
    }

    @Path(value="/send-dynamic/service")
    @GET
    @Produces(value={"application/json"})
    public JsonObject get(@QueryParam(value="q") String q, @QueryParam(value="fq") String fq) {
        return Json.createObjectBuilder().add("q", q).add("fq", fq).build();
    }

    @ApplicationScoped
    RoutesBuilder sendDynamicRoutes() {
        return new EndpointRouteBuilder(){

            public void configure() throws Exception {
                DirectEndpointBuilderFactory.DirectEndpointBuilder trigger = this.direct("send-dynamic");
                HttpEndpointBuilderFactory.HttpEndpointBuilder service = this.http("localhost:${header.SendDynamicHttpEndpointPort}/test/client/http/send-dynamic/service?q=*&fq=publication_date:%5B${date:now-72h:yyyy-MM-dd}T00:00:00Z%20TO%20${date:now-24h:yyyy-MM-dd}T23:59:59Z%5D&wt=xml&indent=false&start=0&rows=100");
                ((RouteDefinition)((ProcessorDefinition)this.from((EndpointConsumerBuilder)trigger).setHeader("CamelHttpMethod").constant((Object)"GET")).toD((EndpointProducerBuilder)service)).convertBodyTo(String.class);
            }
        };
    }

    @Path(value="/operation/failed/exception")
    @GET
    @Produces(value={"text/plain"})
    public String operationFailedException() {
        this.producerTemplate.to("direct:httpOperationFailedException").send();
        return (String)this.consumerTemplate.receiveBody("seda:dlq", 5000L, String.class);
    }

    @Path(value="/compression")
    @GET
    @Produces(value={"text/plain"})
    public String compression() {
        return (String)this.producerTemplate.toF("http://localhost:%d/service/common/compress", new Object[]{ConfigProvider.getConfig().getValue("quarkus.http.test-port", Integer.class)}).withHeader("CamelHttpMethod", (Object)"GET").withHeader("Accept-Encoding", (Object)"gzip, deflate").request(String.class);
    }
}

