/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.http.http.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.http.common.AbstractHttpTest;
import org.apache.camel.quarkus.component.http.common.HttpTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=HttpTestResource.class)
public class HttpTest
extends AbstractHttpTest {
    public String component() {
        return "http";
    }

    @Test
    public void basicAuthCache() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).when().get("/test/client/{component}/auth/basic/cache", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)("Component " + this.component() + " is using basic auth")), new Matcher[0]);
    }

    @Test
    public void sendDynamic() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("test-port", new Object[]{RestAssured.port}).accept(ContentType.JSON).when().get("/test/client/{component}/send-dynamic", new Object[]{this.component()})).then()).statusCode(200)).body("q", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())), new Object[]{"fq", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty()))});
    }

    @Test
    public void httpOperationFailedException() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/test/client/{component}/operation/failed/exception", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"Handled HttpOperationFailedException"), new Matcher[0]);
    }

    @Test
    public void compression() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/test/client/{component}/compression", new Object[]{this.component()})).then()).statusCode(200)).body(Matchers.is((Object)"Compressed response"), new Matcher[0]);
    }
}

