/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.zipfile.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class ZipfileTest {
    ZipfileTest() {
    }

    @Test
    public void test() throws Exception {
        ExtractableResponse response = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Hello World").post("/zipfile/post", new Object[0])).then()).extract();
        byte[] body = response.body().asByteArray();
        Assertions.assertNotNull((Object)body);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(body));
        ZipEntry entry = zis.getNextEntry();
        if (entry != null) {
            IOHelper.copy((InputStream)zis, (OutputStream)bos);
        }
        String str = bos.toString();
        Assertions.assertEquals((Object)"Hello World", (Object)str);
    }
}

