/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.zendesk.it;

import java.util.Map;
import org.apache.camel.quarkus.test.wiremock.WireMockTestResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;

public class ZendeskTestResource
extends WireMockTestResourceLifecycleManager {
    private static final String ZENDESK_ENV_USERNAME = "ZENDESK_USERNAME";
    private static final String ZENDESK_ENV_PASSWORD = "ZENDESK_PASSWORD";
    private static final String ZENDESK_ENV_SERVER_URL = "ZENDESK_SERVER_URL";

    public Map<String, String> start() {
        Map properties = super.start();
        String wiremockUrl = (String)properties.get("wiremock.url");
        String serverUrl = wiremockUrl != null ? wiremockUrl : System.getenv(ZENDESK_ENV_SERVER_URL);
        return CollectionHelper.mergeMaps((Map)properties, (Map[])new Map[]{CollectionHelper.mapOf((Object)"camel.component.zendesk.username", (Object)this.envOrDefault(ZENDESK_ENV_USERNAME, "test"), (Object[])new Object[]{"camel.component.zendesk.password", this.envOrDefault(ZENDESK_ENV_PASSWORD, "2se3r3t"), "camel.component.zendesk.server-url", serverUrl})});
    }

    protected String getRecordTargetBaseUrl() {
        return System.getenv(ZENDESK_ENV_SERVER_URL);
    }

    protected boolean isMockingEnabled() {
        return !this.envVarsPresent(new String[]{ZENDESK_ENV_USERNAME, ZENDESK_ENV_PASSWORD, ZENDESK_ENV_SERVER_URL});
    }
}

