/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.zendesk.it;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.zendesk.client.v2.model.Ticket;

@Path(value="/zendesk")
public class ZendeskResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/ticket")
    @GET
    public Response getTicket(@QueryParam(value="ticketId") long ticketId) {
        Ticket result = (Ticket)this.producerTemplate.requestBody("zendesk:default/getTicket?inBody=id", (Object)ticketId, Ticket.class);
        if (result != null) {
            return Response.ok((Object)result.getDescription()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="/ticket")
    @POST
    public Response createTicket(String description) throws Exception {
        Ticket input = new Ticket();
        input.setSubject("Camel Quarkus Test Subject");
        input.setDescription(description);
        Ticket created = (Ticket)this.producerTemplate.requestBody("zendesk:default/createTicket?inBody=ticket", (Object)input, Ticket.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)created.getId()).build();
    }

    @Path(value="/ticket")
    @DELETE
    public Response deleteTicket(@QueryParam(value="ticketId") long ticketId) {
        this.producerTemplate.requestBody("zendesk:default/deleteTicket?inBody=id", (Object)ticketId, Ticket.class);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

