/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import io.quarkus.test.junit.DisabledOnIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
public class XsltTest {
    private static final String BODY = "<mail><subject>Hey</subject><body>Hello world!</body></mail>";

    private static Stream<Arguments> matrix() {
        return Stream.of(Arguments.of((Object[])new Object[]{"xslt", "string"}), Arguments.of((Object[])new Object[]{"xslt", "bytes"}), Arguments.of((Object[])new Object[]{"xslt", "dom"}), Arguments.of((Object[])new Object[]{"xslt", "file"}), Arguments.of((Object[])new Object[]{"xslt-saxon", "string"}), Arguments.of((Object[])new Object[]{"xslt-saxon", "bytes"}), Arguments.of((Object[])new Object[]{"xslt-saxon", "dom"}), Arguments.of((Object[])new Object[]{"xslt-saxon", "file"}));
    }

    @ParameterizedTest
    @MethodSource(value={"matrix"})
    public void xslt(String component, String output) throws Exception {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/" + component + "?output=" + output, new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        if (output.equals("dom")) {
            Assertions.assertEquals((Object)"<classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)actual);
        } else {
            Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)actual);
        }
        if (output.equals("file")) {
            Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)Files.readString(Path.of("target/xsltme.xml", new String[0]), Charset.forName("ISO-8859-1")).replaceAll(">\\s+<", "><").replaceAll("[\\n\\r]", ""));
        }
    }

    @Test
    public void saxonStAX() {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/stax", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)actual);
    }

    @Test
    public void xsltExtensionFunction() {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/xslt-extension-function", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><extension-function-xsl>Hey-Hello world!</extension-function-xsl>", (Object)actual);
    }

    @Test
    @DisabledOnIntegrationTest(value="xslt-saxon extension function does not be supported in native mode")
    public void saxonExtensionFunction() {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/xslt-saxon-extension-function", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Test1>3</Test1><Test2>abccde</Test2><Test3>xyz</Test3>", (Object)actual);
    }

    @ParameterizedTest
    @ValueSource(strings={"xslt", "xslt-saxon"})
    public void xsltCustomURIResolver(String component) {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/" + component + "/custom-uri-resolver", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><data>FOO DATA</data>", (Object)actual);
    }

    @ParameterizedTest
    @ValueSource(strings={"xslt", "xslt-saxon"})
    @DisabledOnIntegrationTest(value="Generating xslt templates dynamically does not be supported in native mode")
    public void xsltInclude(String component) {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/" + component + "/include", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)actual);
    }

    @ParameterizedTest
    @ValueSource(strings={"xslt", "xslt-saxon"})
    @DisabledOnIntegrationTest(value="forwarding xslt error and warn messages does not be supported in native mode")
    public void xsltTerminate(String component) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("<staff><programmer><name>Daisy Duck</name><dob></dob></programmer></staff>").post("/xml/" + component + "/terminate", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Error: DOB is an empty string!"), new Matcher[0]);
    }

    @Test
    public void htmlTransform() throws Exception {
        String html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.html"), (Charset)Charset.forName("UTF-8"));
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.HTML).accept(ContentType.TEXT).body(html).post("/xml/html-transform", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"><title>Title</title></head><body><h1>Title</h1><p>Paragraph Contents</p></body></html>", (Object)actual);
    }

    @Test
    public void htmlToText() throws Exception {
        String html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.html"), (Charset)Charset.forName("UTF-8"));
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.HTML).accept(ContentType.TEXT).body(html).post("/xml/html-to-text", new Object[0])).then()).statusCode(200)).extract().body().asString().trim();
        Assertions.assertEquals((Object)("= Title" + System.lineSeparator() + System.lineSeparator() + "Paragraph Contents"), (Object)actual);
    }

    @Test
    public void xpathLanguage() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body("<orders><order><id>1</id><country>UK</country><total>2.54</total></order></orders>").post("/xml/xpath", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Country UK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body("<orders><order><id>1</id><country>FR</country><total>9.99</total></order></orders>").post("/xml/xpath", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Invalid country code"), new Matcher[0]);
    }

    @Test
    public void xtokenizeLanguage() {
        String expectedResult = "<c:child some_attr='a' anotherAttr='a' xmlns:c=\"urn:c\"></c:child>,<c:child some_attr='b' anotherAttr='b' xmlns:c=\"urn:c\"></c:child>";
        String xml = "<?xml version='1.0' encoding='UTF-8'?><c:parent xmlns:c='urn:c'><c:child some_attr='a' anotherAttr='a'></c:child><c:child some_attr='b' anotherAttr='b'></c:child></c:parent>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(xml).post("/xml/xtokenize", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)expectedResult), new Matcher[0]);
    }
}

