/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;

@Dependent
public class XsltBeanProducers {
    @Inject
    CamelContext context;

    @Named(value="xslt_bean")
    public XsltBean getXsltBean() {
        return new XsltBean();
    }

    private static String getXsltContent() throws Exception {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("xslt/classpath-transform.xsl");){
            String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static class XsltBean {
        public String getXsltResource() throws Exception {
            return XsltBeanProducers.getXsltContent();
        }
    }
}

