/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.language.xpath;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class XPathTest {
    @Test
    public void transformShouldSucceed() throws IOException {
        String xml = IOUtils.toString((InputStream)XPathTest.class.getResourceAsStream("/students.xml"), (Charset)StandardCharsets.UTF_8);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/transform", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"ClausHadrian"), new Matcher[0]);
    }

    @Test
    public void whenPredicateShouldMatchWhenIdHasValueA() {
        String xml = "<body id='a'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/choice", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"A"), new Matcher[0]);
    }

    @Test
    public void concatCoreXPathFunctionShouldPrependFooBeforeMonica() {
        String xml = "<person name='Monica'/>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/coreXPathFunctions", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"foo-Monica"), new Matcher[0]);
    }

    @Test
    public void headerCamelXPathFunctionShouldMatchFooHeaderWhenValueIsBar() {
        String fooHeader = "bar";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(fooHeader).when().get("/xpath/camelXPathFunctions", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"BAR"), new Matcher[0]);
    }

    @Test
    public void xpathLoadedFromResourceShouldSucceed() {
        String xml = "<person><name>Caroline</name></person>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/resource", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Caroline"), new Matcher[0]);
    }

    @Test
    public void xpathAnnotationAppliedOnPriceBeanMethodParameterShouldSucceed() {
        String xml = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><price>38</price></env:Body></env:Envelope>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/annotation", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"38.0\u20ac"), new Matcher[0]);
    }

    @Test
    public void xpathWithPropertiesFunctionShouldMatchWhenTypeHeaderHasValueCamel() {
        String typeHeaderValue = "Camel";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(typeHeaderValue).when().get("/xpath/properties", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"FOO"), new Matcher[0]);
    }

    @Test
    public void xpathWithSimpleFunctionEvaluatingBarPropertyShouldMatchWhenNameIsKong() {
        String xml = "<name>Kong</name>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(xml).when().get("/xpath/simple", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"BAR"), new Matcher[0]);
    }
}

