/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xmlsecurity.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import javax.crypto.SecretKey;
import org.apache.camel.builder.RouteBuilder;

@ApplicationScoped
public class XmlsecurityRoutes
extends RouteBuilder {
    @Inject
    @Named(value="key")
    SecretKey key;

    public void configure() throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("test", "http://test/test");
        this.from("direct:enveloping-sign").to("xmlsecurity-sign:enveloping?keyAccessor=#accessor");
        this.from("direct:enveloping-verify").to("xmlsecurity-verify:enveloping?keySelector=#selector");
        this.from("direct:enveloped-sign").to("xmlsecurity-sign:enveloped?keyAccessor=#accessor&parentLocalName=root");
        this.from("direct:enveloped-verify").to("xmlsecurity-verify:enveloped?keySelector=#selector");
        this.from("direct:plaintext-sign").to("xmlsecurity-sign:plaintext?keyAccessor=#accessor&plainText=true&plainTextEncoding=UTF-8");
        this.from("direct:plaintext-verify").to("xmlsecurity-verify:plaintext?keySelector=#selector");
        this.from("direct:canonicalization-sign").to("xmlsecurity-sign:canonicalization?keyAccessor=#accessor&canonicalizationMethod=#canonicalizationMethod&signatureAlgorithm=http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        this.from("direct:canonicalization-verify").to("xmlsecurity-verify:canonicalization?keySelector=#selector");
        this.from("direct:signaturedigestalgorithm-sign").to("xmlsecurity-sign:signaturedigestalgorithm?keyAccessor=#accessor&signatureAlgorithm=http://www.w3.org/2001/04/xmldsig-more#rsa-sha512&digestAlgorithm=http://www.w3.org/2001/04/xmlenc#sha512");
        this.from("direct:signaturedigestalgorithm-verify").to("xmlsecurity-verify:signaturedigestalgorithm?keySelector=#selector");
        this.from("direct:transformsXPath-sign").to("xmlsecurity-sign:transformsXPath?keyAccessor=#accessor&transformMethods=#transformsXPath");
        this.from("direct:transformsXPath-verify").to("xmlsecurity-verify:transformsXPath?keySelector=#selector");
        this.from("direct:transformsXsltXPath-sign").to("xmlsecurity-sign:transformsXsltXPath?keyAccessor=#accessor&transformMethods=#transformsXsltXPath&cryptoContextProperties=#cryptoContextProperties");
        this.from("direct:transformsXsltXPath-verify").to("xmlsecurity-verify:transformsXsltXPath?keySelector=#selector&secureValidation=false&cryptoContextProperties=#cryptoContextProperties");
        this.from("direct:marshal").marshal().xmlSecurity(this.key.getEncoded());
        this.from("direct:unmarshal").unmarshal().xmlSecurity(this.key.getEncoded());
        this.from("direct:marshal-partial").marshal().xmlSecurity("//root/test:child-2", namespaces, true, this.key.getEncoded());
        this.from("direct:unmarshal-partial").unmarshal().xmlSecurity("//root/test:child-2", namespaces, true, this.key.getEncoded());
    }
}

