/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xmlsecurity.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;

@Path(value="/xmlsecurity")
public class XmlsecurityResource {
    @Inject
    ProducerTemplate template;

    @Path(value="/component/sign/enveloping")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signEnveloping(String xml) throws Exception {
        return (String)this.template.requestBody("direct:enveloping-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/enveloping")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifyEnveloping(String xml) throws Exception {
        return (String)this.template.requestBody("direct:enveloping-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/enveloped")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signEnveloped(String xml) throws Exception {
        return (String)this.template.requestBody("direct:enveloped-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/enveloped")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifyEnveloped(String xml) throws Exception {
        return (String)this.template.requestBody("direct:enveloped-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/plaintext")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signPlainText(String xml) throws Exception {
        return (String)this.template.requestBody("direct:plaintext-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/plaintext")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifyPlainText(String xml) throws Exception {
        return (String)this.template.requestBody("direct:plaintext-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/canonicalization")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signCanonicalization(String xml) throws Exception {
        return (String)this.template.requestBody("direct:canonicalization-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/canonicalization")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifyCanonicalization(String xml) throws Exception {
        return (String)this.template.requestBody("direct:canonicalization-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/signaturedigest")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signSignatureAndDigestAlgorithm(String xml) throws Exception {
        return (String)this.template.requestBody("direct:signaturedigestalgorithm-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/signaturedigest")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifySignatureAndDigestAlgorithm(String xml) throws Exception {
        return (String)this.template.requestBody("direct:signaturedigestalgorithm-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/transformsxpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signSignatureTransformsXPath(String xml) throws Exception {
        return (String)this.template.requestBody("direct:transformsXPath-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/transformsxpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifySignatureTransformsXPath(String xml) throws Exception {
        return (String)this.template.requestBody("direct:transformsXPath-verify", (Object)xml, String.class);
    }

    @Path(value="/component/sign/transformsxsltxpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String signSignatureTransformsXsltXPath(String xml) throws Exception {
        return (String)this.template.requestBody("direct:transformsXsltXPath-sign", (Object)xml, String.class);
    }

    @Path(value="/component/verify/transformsxsltxpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String verifySignatureTransformsXsltXPath(String xml) throws Exception {
        return (String)this.template.requestBody("direct:transformsXsltXPath-verify", (Object)xml, String.class);
    }

    @Path(value="/dataformat/marshal")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String dataformatMarshal(String xml) throws Exception {
        return (String)this.template.requestBody("direct:marshal", (Object)xml, String.class);
    }

    @Path(value="/dataformat/unmarshal")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String dataformatUnmarshal(String xml) throws Exception {
        return (String)this.template.requestBody("direct:unmarshal", (Object)xml, String.class);
    }

    @Path(value="/dataformat/marshal/partial")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String dataformatMarshalPartialContent(String xml) throws Exception {
        return (String)this.template.requestBody("direct:marshal-partial", (Object)xml, String.class);
    }

    @Path(value="/dataformat/unmarshal/partial")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public String dataformatUnmarshalPartialContent(String xml) throws Exception {
        return (String)this.template.requestBody("direct:unmarshal-partial", (Object)xml, String.class);
    }
}

