/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xmlsecurity.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.XPathType;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.w3c.dom.Node;

@ApplicationScoped
public class XmlsecurityProducers {
    @Produces
    @Named(value="accessor")
    public KeyAccessor getAccessor(final KeyPair keyPair) {
        return new KeyAccessor(){

            public KeySelector getKeySelector(Message message) throws Exception {
                return KeySelector.singletonKeySelector(keyPair.getPrivate());
            }

            public KeyInfo getKeyInfo(Message mess, Node messageBody, KeyInfoFactory keyInfoFactory) throws Exception {
                return null;
            }
        };
    }

    @Produces
    @Named(value="selector")
    public KeySelector getSelector(final KeyPair keyPair) {
        return new KeySelector(){

            @Override
            public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xmlCryptoContext) {
                return () -> keyPair.getPublic();
            }
        };
    }

    @Produces
    @Named(value="canonicalizationMethod")
    public AlgorithmMethod getCanonicalizationMethod() {
        ArrayList<String> inclusivePrefixes = new ArrayList<String>();
        inclusivePrefixes.add("ds");
        return XmlSignatureHelper.getCanonicalizationMethod((String)"http://www.w3.org/2001/10/xml-exc-c14n#", inclusivePrefixes);
    }

    @Produces
    @Named(value="transformsXPath")
    public List<AlgorithmMethod> getTransformsXPathMethod() {
        ArrayList<XmlSignatureHelper.XPathAndFilter> list = new ArrayList<XmlSignatureHelper.XPathAndFilter>(3);
        XmlSignatureHelper.XPathAndFilter xpath1 = new XmlSignatureHelper.XPathAndFilter("//n0:ToBeSigned", XPathType.Filter.INTERSECT.toString());
        list.add(xpath1);
        XmlSignatureHelper.XPathAndFilter xpath2 = new XmlSignatureHelper.XPathAndFilter("//n0:NotToBeSigned", XPathType.Filter.SUBTRACT.toString());
        list.add(xpath2);
        XmlSignatureHelper.XPathAndFilter xpath3 = new XmlSignatureHelper.XPathAndFilter("//n0:ReallyToBeSigned", XPathType.Filter.UNION.toString());
        list.add(xpath3);
        ArrayList<AlgorithmMethod> result = new ArrayList<AlgorithmMethod>();
        result.add(XmlSignatureHelper.getCanonicalizationMethod((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("n0", "http://test/test");
        result.add(XmlSignatureHelper.getXPath2Transform(list, map));
        return result;
    }

    @Produces
    @Named(value="transformsXsltXPath")
    public List<AlgorithmMethod> getTransformsXsltXPathMethod() throws Exception {
        AlgorithmMethod transformXslt = XmlSignatureHelper.getXslTransform((String)"/xslt-test.xsl");
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put("n0", "https://org.apache/camel/xmlsecurity/test");
        AlgorithmMethod transformXpath = XmlSignatureHelper.getXPathTransform((String)"//n0:XMLSecurity/n0:Content", namespaceMap);
        ArrayList<AlgorithmMethod> result = new ArrayList<AlgorithmMethod>();
        result.add(XmlSignatureHelper.getCanonicalizationMethod((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        result.add(transformXslt);
        result.add(transformXpath);
        return result;
    }

    @Singleton
    @Produces
    public KeyPair getKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    @Singleton
    @Produces
    @Named(value="key")
    public SecretKey key() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        keyGenerator.generateKey();
        return keyGenerator.generateKey();
    }

    @Produces
    @Named(value="cryptoContextProperties")
    public Map<String, Object> cryptoContextProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.apache.jcp.xml.dsig.secureValidation", Boolean.FALSE);
        return properties;
    }
}

