/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xmlsecurity.it;

import io.quarkus.test.junit.DisabledOnIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class XmlsecurityTest {
    XmlsecurityTest() {
    }

    @Test
    public void signVerifyEnveloping() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/enveloping", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/enveloping", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void signVerifyEnveloped() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/enveloped", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/enveloped", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void signVerifyPlainText() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/plaintext", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/plaintext", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void signVerifyCanonicalization() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/canonicalization", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/canonicalization", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void signVerifySignatureDigestAlgorithm() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/signaturedigest", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/signaturedigest", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void signVerifyTransformsXPath() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-xpath-test.xml")).post("/xmlsecurity/component/sign/transformsxpath", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/transformsxpath", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @DisabledOnIntegrationTest(value="https://github.com/apache/camel-quarkus/issues/2185")
    @Test
    public void signVerifyTransformsXsltXPath() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/component/sign/transformsxsltxpath", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        String verifiedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/component/verify/transformsxsltxpath", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)verifiedXml.contains("ds:SignatureValue"));
    }

    @Test
    public void dataformatMarshalUnmarshal() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/dataformat/marshal", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("xenc:CipherValue"));
        String unsignedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/dataformat/unmarshal", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertFalse((boolean)unsignedXml.contains("xenc:CipherValue"));
    }

    @Test
    public void dataformatMarshalUnmarshalPartialContent() throws Exception {
        String signedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(this.readXMLFile("/xml-test.xml")).post("/xmlsecurity/dataformat/marshal/partial", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)signedXml.contains("<test:child-2><xenc:EncryptedData"));
        String unsignedXml = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(signedXml).post("/xmlsecurity/dataformat/unmarshal/partial", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)unsignedXml.contains("<test:child-2>Test 2</test:child-2>"));
    }

    private String readXMLFile(String fileName) throws IOException {
        return IOUtils.toString((InputStream)XmlsecurityTest.class.getResourceAsStream(fileName), (Charset)StandardCharsets.UTF_8);
    }
}

