/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlRouteBuilder
extends RouteBuilder {
    public static final String DIRECT_HTML_TO_DOM = "direct:html-to-dom";
    public static final String DIRECT_HTML_TRANSFORM = "direct:html-transfrom";
    public static final String DIRECT_HTML_TO_TEXT = "direct:html-to-text";
    public static final String DIRECT_XML_CBR = "direct:xml-cbr";

    public void configure() {
        this.from(DIRECT_HTML_TO_DOM).unmarshal().tidyMarkup().process(exchange -> {
            Document doc = (Document)exchange.getIn().getBody(Document.class);
            Element html = doc.getDocumentElement();
            if (!"html".equals(html.getLocalName())) {
                throw new IllegalStateException("Expected <html> as the last child of of the document; found " + html.getLocalName());
            }
            Node body = html.getLastChild();
            if (!"body".equals(body.getLocalName())) {
                throw new IllegalStateException("Expected <body> as the last child of <html>; found " + body.getLocalName());
            }
            Node p = body.getFirstChild();
            if (!"p".equals(p.getLocalName())) {
                throw new IllegalStateException("Expected <p> as the first child of <body>; found " + p.getLocalName());
            }
            Node text = p.getFirstChild();
            if (text.getNodeType() != 3) {
                throw new IllegalStateException("Expected a text node as the first child of <p>; found " + text);
            }
            exchange.getIn().setBody((Object)text.getTextContent());
        });
        this.from(DIRECT_HTML_TRANSFORM).unmarshal().tidyMarkup().to("xslt:xslt/html-transform.xsl");
        this.from(DIRECT_HTML_TO_TEXT).unmarshal().tidyMarkup().to("xslt:xslt/html-to-text.xsl");
        ((ChoiceDefinition)this.from(DIRECT_XML_CBR).choice().when((Predicate)this.xpath("//order/country = 'UK'")).setBody((Expression)this.constant("Country UK"))).otherwise().setBody((Expression)this.constant("Invalid country code"));
    }
}

