/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/xml")
@ApplicationScoped
public class XmlResource {
    private static final Logger LOG = Logger.getLogger(XmlResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/html-parse")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlParse(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-to-dom", (Object)html, String.class);
    }

    @Path(value="/xslt")
    @POST
    @Produces(value={"text/plain"})
    public String classpath(String body) throws Exception {
        return (String)this.producerTemplate.requestBody("xslt:xslt/classpath-transform.xsl", (Object)body, String.class);
    }

    @Path(value="/html-transform")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlTransform(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-transfrom", (Object)html, String.class);
    }

    @Path(value="/html-to-text")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlToText(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-to-text", (Object)html, String.class);
    }

    @Path(value="/xpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public String xpath(String message) {
        return (String)this.producerTemplate.requestBody("direct:xml-cbr", (Object)message, String.class);
    }
}

