/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class XmlTest {
    private static final String BODY = "<mail><subject>Hey</subject><body>Hello world!</body></mail>";

    XmlTest() {
    }

    @Test
    public void htmlParse() throws Exception {
        String html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.html"), (Charset)Charset.forName("UTF-8"));
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.HTML).accept(ContentType.TEXT).body(html).post("/xml/html-parse", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Paragraph Contents"), new Matcher[0]);
    }

    @Test
    public void xslt() {
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(BODY).post("/xml/xslt", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><classpath-xsl subject=\"Hey\"><cheese><mail><subject>Hey</subject><body>Hello world!</body></mail></cheese></classpath-xsl>", (Object)actual);
    }

    @Test
    public void htmlTransform() throws Exception {
        String html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.html"), (Charset)Charset.forName("UTF-8"));
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.HTML).accept(ContentType.TEXT).body(html).post("/xml/html-transform", new Object[0])).then()).statusCode(200)).extract().body().asString().trim().replaceAll(">\\s+<", "><");
        Assertions.assertEquals((Object)"<html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"><title>Title</title></head><body><h1>Title</h1><p>Paragraph Contents</p></body></html>", (Object)actual);
    }

    @Test
    public void htmlToText() throws Exception {
        String html = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test.html"), (Charset)Charset.forName("UTF-8"));
        String actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.HTML).accept(ContentType.TEXT).body(html).post("/xml/html-to-text", new Object[0])).then()).statusCode(200)).extract().body().asString().trim();
        Assertions.assertEquals((Object)"= Title\n\nParagraph Contents", (Object)actual);
    }

    @Test
    public void xpathLanguage() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body("<orders><order><id>1</id><country>UK</country><total>2.54</total></order></orders>").post("/xml/xpath", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Country UK"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body("<orders><order><id>1</id><country>FR</country><total>9.99</total></order></orders>").post("/xml/xpath", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Invalid country code"), new Matcher[0]);
    }
}

