/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.jaxp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.xml.BytesSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlJaxpRoutes
extends RouteBuilder {
    public void configure() throws Exception {
        ((RouteDefinition)((RouteDefinition)this.from("direct:documentConvert").convertBodyTo(Document.class)).process(exchange -> {
            Document document = (Document)exchange.getMessage().getBody(Document.class);
            Element element = document.createElement("bar");
            element.setTextContent("Bar Text");
            document.getDocumentElement().appendChild(element);
        })).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:elementConvert").convertBodyTo(Document.class)).process(exchange -> {
            Document document = (Document)exchange.getMessage().getBody(Document.class);
            Element element = document.createElement("bar");
            element.setTextContent("Bar Text");
            document.getDocumentElement().appendChild(element);
        })).convertBodyTo(Element.class)).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)this.from("direct:byteSourceConvert").convertBodyTo(byte[].class)).convertBodyTo(BytesSource.class)).convertBodyTo(String.class);
        ((RouteDefinition)this.from("direct:sourceConvert").convertBodyTo(Source.class)).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)this.from("direct:domSourceConvert").convertBodyTo(byte[].class)).convertBodyTo(DOMSource.class)).convertBodyTo(String.class);
        ((RouteDefinition)this.from("direct:saxSourceConvert").convertBodyTo(SAXSource.class)).convertBodyTo(String.class);
        ((RouteDefinition)this.from("direct:staxSourceConvert").convertBodyTo(StAXSource.class)).convertBodyTo(String.class);
        ((RouteDefinition)this.from("direct:streamSourceConvert").convertBodyTo(StreamSource.class)).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)this.from("direct:streamSourceReaderConvert").convertBodyTo(StreamSource.class)).convertBodyTo(Reader.class)).convertBodyTo(String.class);
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:xmlStreamReaderCharsetConvert").convertBodyTo(InputStream.class, StandardCharsets.ISO_8859_1.name())).convertBodyTo(XMLStreamReader.class)).process(exchange -> {
            Message message = exchange.getMessage();
            XMLStreamReader reader = (XMLStreamReader)message.getBody(XMLStreamReader.class);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            exchange.setProperty("CamelCharsetName", (Object)StandardCharsets.UTF_8.name());
            XMLStreamWriter writer = (XMLStreamWriter)exchange.getContext().getTypeConverter().mandatoryConvertTo(XMLStreamWriter.class, exchange, (Object)output);
            block7: while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 7: {
                        writer.writeStartDocument();
                        continue block7;
                    }
                    case 8: {
                        writer.writeEndDocument();
                        continue block7;
                    }
                    case 1: {
                        writer.writeStartElement(reader.getName().getLocalPart());
                        continue block7;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                        continue block7;
                    }
                    case 2: {
                        writer.writeEndElement();
                        continue block7;
                    }
                }
            }
            reader.close();
            writer.close();
            message.setBody((Object)output);
        })).convertBodyTo(String.class, StandardCharsets.UTF_8.name());
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:nodeListConvert").convertBodyTo(Document.class)).process(exchange -> {
            Message message = exchange.getMessage();
            Document document = (Document)message.getBody(Document.class);
            NodeList nodeList = document.getElementsByTagName("foo");
            message.setBody((Object)nodeList);
        })).convertBodyTo(Node.class)).convertBodyTo(String.class);
    }
}

