/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.jaxp;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;

@Path(value="/xml/jaxp")
public class XmlJaxpResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="convert")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @POST
    public String applyXmlJaxpTypeConversion(@QueryParam(value="endpointUri") String endpointUri, String xml) {
        return (String)this.producerTemplate.requestBody(endpointUri, (Object)xml, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="convert/context/global/options")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @POST
    public String applyXmlJaxpTypeConversionWithContextGlobalProperties(@QueryParam(value="endpointUri") String endpointUri, String xml) {
        try {
            this.context.getGlobalOptions().put("org.apache.camel.xmlconverter.output.encoding", "UTF-8");
            this.context.getGlobalOptions().put("org.apache.camel.xmlconverter.output.standalone", "no");
            String string = this.applyXmlJaxpTypeConversion(endpointUri, xml);
            return string;
        }
        finally {
            this.context.getGlobalOptions().remove("org.apache.camel.xmlconverter.output.");
            this.context.getGlobalOptions().remove("org.apache.camel.xmlconverter.output.");
        }
    }
}

