/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.jaxp;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class XmlJaxpTest {
    private static final String XML_PAYLOAD = "<root><foo>Foo Text</foo></root>";
    private static final String XML_PAYLOAD_WITH_UMLAUT = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root><foo>Foo Text With Umlaut \u00e4\u00f6\u00fc</foo></root>";

    XmlJaxpTest() {
    }

    @Test
    void documentConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:documentConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[]{"root.bar", Matchers.equalTo((Object)"Bar Text")});
    }

    @Test
    void elementConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:elementConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[]{"root.bar", Matchers.equalTo((Object)"Bar Text")});
    }

    @Test
    void byteSourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:byteSourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void sourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:sourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void domSourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:domSourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void saxSourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:saxSourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void staxSourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:staxSourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void streamSourceConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:streamSourceConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void streamSourceReaderConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:streamSourceReaderConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }

    @Test
    void xmlStreamReaderCharsetConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:xmlStreamReaderCharsetConvert"}).contentType("application/xml").body(XML_PAYLOAD_WITH_UMLAUT).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("root.foo", Matchers.equalTo((Object)"Foo Text With Umlaut \u00e4\u00f6\u00fc"), new Object[0]);
    }

    @Test
    void contextGlobalOptionsConversion() {
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:documentConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert/context/global/options", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)result.contains("encoding=\"UTF-8\""));
        Assertions.assertTrue((boolean)result.contains("standalone=\"no\""));
    }

    @Test
    void nodeListConversion() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:nodeListConvert"}).contentType("application/xml").body(XML_PAYLOAD).post("/xml/jaxp/convert", new Object[0])).then()).statusCode(200)).body("foo", Matchers.equalTo((Object)"Foo Text"), new Object[0]);
    }
}

