/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.StringJoiner;
import net.sf.saxon.trans.XPathException;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/xml")
@ApplicationScoped
public class XsltResource {
    private static final Logger LOG = Logger.getLogger(XsltResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/stax")
    @POST
    @Produces(value={"text/plain"})
    public String stax(String body) {
        return (String)this.producerTemplate.requestBody("xslt-saxon:xslt/classpath-transform.xsl?allowStAX=true", (Object)body, String.class);
    }

    @Path(value="/{component}")
    @POST
    @Produces(value={"text/plain"})
    public String classpath(@PathParam(value="component") String component, @QueryParam(value="output") @DefaultValue(value="string") String output, String body) {
        if (output.equals("file")) {
            return (String)this.producerTemplate.requestBodyAndHeader(component + ":xslt/classpath-transform.xsl?output=file", (Object)body, "CamelXsltFileName", (Object)"target/xsltme.xml", String.class);
        }
        return (String)this.producerTemplate.requestBody(component + ":xslt/classpath-transform.xsl?output=" + output, (Object)body, String.class);
    }

    @Path(value="/{component}/include")
    @POST
    @Produces(value={"text/plain"})
    public String xsltInclude(@PathParam(value="component") String component, String body) {
        return (String)this.producerTemplate.requestBody(component + ":xslt/include.xsl", (Object)body, String.class);
    }

    @Path(value="/{component}/terminate")
    @POST
    @Produces(value={"text/plain"})
    public String xsltTerminate(@PathParam(value="component") String component, String body) throws Exception {
        Exchange out = this.producerTemplate.request(component + ":xslt/terminate.xsl", exchange -> exchange.getIn().setBody((Object)body));
        if (component.equals("xslt")) {
            Exception warning = (Exception)out.getProperty("CamelXsltWarning", Exception.class);
            return warning.getMessage();
        }
        if (component.equals("xslt-saxon")) {
            Exception error = (Exception)out.getProperty("CamelXsltFatalError", Exception.class);
            return ((XPathException)error).getErrorObject().head().getStringValue();
        }
        return "";
    }

    @Path(value="/xslt-extension-function")
    @POST
    @Produces(value={"text/plain"})
    public String extensionFunction(String body) {
        return (String)this.producerTemplate.requestBody("xslt:xslt/extension-function.xsl", (Object)body, String.class);
    }

    @Path(value="/xslt-saxon-extension-function")
    @POST
    @Produces(value={"text/plain"})
    public String saxonExtensionFunction(String body) {
        return (String)this.producerTemplate.requestBody("xslt-saxon:xslt/saxon-extension-function.xsl?saxonExtensionFunctions=#function1,#function2", (Object)body, String.class);
    }

    @Path(value="/{component}/custom-uri-resolver")
    @POST
    @Produces(value={"text/plain"})
    public String customURIResolver(@PathParam(value="component") String component, String body) {
        return (String)this.producerTemplate.requestBody(component + ":xslt/include_not_existing_resource.xsl?uriResolver=#customURIResolver", (Object)body, String.class);
    }

    @Path(value="/html-transform")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlTransform(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-transform", (Object)html, String.class);
    }

    @Path(value="/html-to-text")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlToText(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-to-text", (Object)html, String.class);
    }

    @Path(value="/xpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public String xpath(String message) {
        return (String)this.producerTemplate.requestBody("direct:xml-cbr", (Object)message, String.class);
    }

    @Path(value="/xtokenize")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public String tokenize(String message) {
        String tokenizedXML;
        this.producerTemplate.sendBody("direct:xtokenize", (Object)message);
        StringJoiner joiner = new StringJoiner(",");
        while ((tokenizedXML = (String)this.consumerTemplate.receiveBody("seda:xtokenize-result", 500L, String.class)) != null) {
            joiner.add(tokenizedXML);
        }
        return joiner.toString();
    }
}

