/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;

@Dependent
public class XsltProducers {
    public static final String EXPECTED_XML_CONSTANT = "<data>FOO DATA</data>";
    @Inject
    CamelContext context;

    @Named(value="customURIResolver")
    public URIResolver getCustomURIResolver() {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                if (href.equals("xslt/include_not_existing_resource.xsl")) {
                    try {
                        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)XsltProducers.this.context, (String)href);
                        return new StreamSource(is);
                    }
                    catch (Exception e) {
                        throw new TransformerException(e);
                    }
                }
                StreamSource constantResult = new StreamSource(new ByteArrayInputStream(XsltProducers.EXPECTED_XML_CONSTANT.getBytes()));
                return constantResult;
            }
        };
    }
}

