/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XsltRouteBuilder
extends RouteBuilder {
    public static final String DIRECT_HTML_TRANSFORM = "direct:html-transform";
    public static final String DIRECT_HTML_TO_TEXT = "direct:html-to-text";
    public static final String DIRECT_XML_CBR = "direct:xml-cbr";
    public static final String DIRECT_XTOKENIZE = "direct:xtokenize";

    public void configure() {
        ((RouteDefinition)this.from(DIRECT_HTML_TRANSFORM).convertBodyTo(Document.class)).to("xslt:xslt/html-transform.xsl");
        ((RouteDefinition)this.from(DIRECT_HTML_TO_TEXT).convertBodyTo(Document.class)).to("xslt:xslt/html-to-text.xsl");
        ((ChoiceDefinition)this.from(DIRECT_XML_CBR).choice().when((Predicate)this.xpath("//order/country = 'UK'")).process(exchange -> {
            Document body = (Document)exchange.getIn().getBody(Document.class);
            String country = XPathAPI.eval((Node)body, (String)"//order/country").toString();
            exchange.getIn().setBody((Object)("Country " + country));
        })).otherwise().setBody((Expression)this.constant("Invalid country code"));
        ((SplitDefinition)this.from(DIRECT_XTOKENIZE).split().xtokenize("//C:child", new Namespaces("C", "urn:c"))).to("seda:xtokenize-result");
    }
}

