/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xml.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.jboss.logging.Logger;

@Path(value="/xml")
@ApplicationScoped
public class XsltResource {
    private static final Logger LOG = Logger.getLogger(XsltResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext camelContext;

    @Path(value="/xslt")
    @POST
    @Produces(value={"text/plain"})
    public String classpath(@QueryParam(value="output") @DefaultValue(value="string") String output, String body) {
        if (output.equals("file")) {
            return (String)this.producerTemplate.requestBodyAndHeader("xslt:xslt/classpath-transform.xsl?output=file", (Object)body, "CamelXsltFileName", (Object)"target/xsltme.xml", String.class);
        }
        return (String)this.producerTemplate.requestBody("xslt:xslt/classpath-transform.xsl?output=" + output, (Object)body, String.class);
    }

    @Path(value="/xslt_include")
    @POST
    @Produces(value={"text/plain"})
    public String xsltInclude(String body) {
        return (String)this.producerTemplate.requestBody("xslt:xslt/include.xsl", (Object)body, String.class);
    }

    @Path(value="/xslt_terminate")
    @POST
    @Produces(value={"text/plain"})
    public String xsltTerminate(String body) {
        Exchange out = this.producerTemplate.request("xslt:xslt/terminate.xsl", exchange -> exchange.getIn().setBody((Object)body));
        Exception warning = (Exception)out.getProperty("CamelXsltWarning", Exception.class);
        return warning.getMessage();
    }

    @Path(value="/xslt-extension-function")
    @POST
    @Produces(value={"text/plain"})
    public String extensionFunction(String body) {
        return (String)this.producerTemplate.requestBody("xslt:xslt/extension-function.xsl", (Object)body, String.class);
    }

    @Path(value="/xslt-custom-uri-resolver")
    @POST
    @Produces(value={"text/plain"})
    public String customURIResolver(String body) {
        return (String)this.producerTemplate.requestBody("xslt:xslt/include_not_existing_resource.xsl?uriResolver=#customURIResolver", (Object)body, String.class);
    }

    @Path(value="/aggregate")
    @GET
    @Produces(value={"text/plain"})
    public String aggregate() throws Exception {
        MockEndpoint mock = (MockEndpoint)this.camelContext.getEndpoint("mock:transformed", MockEndpoint.class);
        mock.expectedMessageCount(1);
        this.producerTemplate.sendBody("direct:aggregate", (Object)"<item>A</item>");
        this.producerTemplate.sendBody("direct:aggregate", (Object)"<item>B</item>");
        this.producerTemplate.sendBody("direct:aggregate", (Object)"<item>C</item>");
        mock.assertIsSatisfied();
        return (String)((Exchange)mock.getExchanges().get(0)).getIn().getBody(String.class);
    }

    @Path(value="/html-transform")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlTransform(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-transform", (Object)html, String.class);
    }

    @Path(value="/html-to-text")
    @POST
    @Consumes(value={"text/html"})
    @Produces(value={"text/plain"})
    public String htmlToText(String html) {
        LOG.debugf("Parsing HTML %s", (Object)html);
        return (String)this.producerTemplate.requestBody("direct:html-to-text", (Object)html, String.class);
    }

    @Path(value="/xpath")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public String xpath(String message) {
        return (String)this.producerTemplate.requestBody("direct:xml-cbr", (Object)message, String.class);
    }

    @Path(value="/xtokenize")
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public String tokenize(String message) {
        String tokenizedXML;
        this.producerTemplate.sendBody("direct:xtokenize", (Object)message);
        StringJoiner joiner = new StringJoiner(",");
        while ((tokenizedXML = (String)this.consumerTemplate.receiveBody("seda:xtokenize-result", 500L, String.class)) != null) {
            joiner.add(tokenizedXML);
        }
        return joiner.toString();
    }
}

