/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xchange.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.xchange.XChangeComponent;
import org.apache.camel.spi.annotations.Component;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.kraken.KrakenExchange;

@Path(value="/xchange")
@ApplicationScoped
public class XchangeResource {
    public static final String DEFAULT_CRYPTO_EXCHANGE = "binance";
    public static final String ALTERNATIVE_CRYPTO_EXCHANGE = "kraken";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/ticker/{exchange}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencyTicker(@PathParam(value="exchange") String cryptoExchange, @QueryParam(value="currencyPair") String currencyPair) {
        Ticker ticker = (Ticker)this.producerTemplate.requestBody("xchange:" + cryptoExchange + "?service=marketdata&method=ticker&currencyPair=" + currencyPair, null, Ticker.class);
        return Json.createObjectBuilder().add("last", ticker.getLast().longValue()).add("bid", ticker.getBid().longValue()).add("ask", ticker.getAsk().longValue()).build();
    }

    @Path(value="/currency")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencies() {
        List currencies = (List)this.producerTemplate.requestBody("xchange:binance?service=metadata&method=currencies", null, List.class);
        JsonArrayBuilder builder = Json.createArrayBuilder();
        currencies.forEach(c -> builder.add(c.getSymbol()));
        return Json.createObjectBuilder().add("currencies", (JsonValue)builder.build()).build();
    }

    @Path(value="/currency/metadata/{symbol}")
    @GET
    @Produces(value={"text/plain"})
    public String currencyMetadata(@PathParam(value="symbol") String symbol) {
        CurrencyMetaData metaData = (CurrencyMetaData)this.producerTemplate.requestBody("xchange:binance?service=metadata&method=currencyMetaData", (Object)Currency.getInstance((String)symbol), CurrencyMetaData.class);
        return metaData.getScale().toString();
    }

    @Path(value="/currency/pairs")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencyPairs() {
        List currencyPairs = (List)this.producerTemplate.requestBody("xchange:binance?service=metadata&method=currencyPairs", null, List.class);
        JsonArrayBuilder builder = Json.createArrayBuilder();
        currencyPairs.forEach(cp -> builder.add(cp.toString()));
        return Json.createObjectBuilder().add("currencyPairs", (JsonValue)builder.build()).build();
    }

    @Path(value="/currency/pairs/metadata")
    @GET
    @Produces(value={"text/plain"})
    public String currencyPairsMetadata(@QueryParam(value="base") String base, @QueryParam(value="counter") String counter) {
        InstrumentMetaData metaData = (InstrumentMetaData)this.producerTemplate.requestBody("xchange:binance?service=metadata&method=currencyPairMetaData", (Object)new CurrencyPair(base, counter), InstrumentMetaData.class);
        return metaData.getTradingFee().toPlainString();
    }

    @Named(value="xchange")
    public XChangeComponent xChangeComponent() {
        Config config = ConfigProvider.getConfig();
        Optional wireMockUrl = config.getOptionalValue("wiremock.url", String.class);
        if (wireMockUrl.isPresent()) {
            return new WireMockedXChangeComponent();
        }
        return new XChangeComponent();
    }

    @Component(value="xchange")
    static final class WireMockedXChangeComponent
    extends XChangeComponent {
        WireMockedXChangeComponent() {
        }

        protected Exchange createExchange(Class<? extends Exchange> exchangeClass) {
            String wireMockUrlProperty;
            if (exchangeClass.equals(BinanceExchange.class)) {
                wireMockUrlProperty = "wiremock.binance.url";
            } else if (exchangeClass.equals(KrakenExchange.class)) {
                wireMockUrlProperty = "wiremock.kraken.url";
            } else {
                throw new IllegalStateException("Unsupported WireMocked exchange " + exchangeClass.getSimpleName());
            }
            Config config = ConfigProvider.getConfig();
            String wireMockUrl = (String)config.getValue(wireMockUrlProperty, String.class);
            URI uri = URI.create(wireMockUrl);
            ExchangeSpecification specification = new ExchangeSpecification(exchangeClass);
            specification.setHost("localhost");
            specification.setPort(uri.getPort());
            specification.setSslUri(wireMockUrl);
            return ExchangeFactory.INSTANCE.createExchange(specification);
        }
    }
}

