/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xchange.it;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;

@Path(value="/xchange")
@ApplicationScoped
public class XchangeResource {
    public static final String DEFAULT_CRYPTO_EXCHANGE = "kraken";
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/ticker/{exchange}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencyTicker(@PathParam(value="exchange") String cryptoExchange, @QueryParam(value="currencyPair") String currencyPair) {
        Ticker ticker = (Ticker)this.producerTemplate.requestBody("xchange:" + cryptoExchange + "?service=marketdata&method=ticker&currencyPair=" + currencyPair, null, Ticker.class);
        return Json.createObjectBuilder().add("last", ticker.getLast().longValue()).add("bid", ticker.getBid().longValue()).add("ask", ticker.getAsk().longValue()).build();
    }

    @Path(value="/currency")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencies() {
        List currencies = (List)this.producerTemplate.requestBody("xchange:kraken?service=metadata&method=currencies", null, List.class);
        JsonArrayBuilder builder = Json.createArrayBuilder();
        currencies.forEach(c -> builder.add(c.getSymbol()));
        return Json.createObjectBuilder().add("currencies", (JsonValue)builder.build()).build();
    }

    @Path(value="/currency/metadata/{symbol}")
    @GET
    @Produces(value={"text/plain"})
    public String currencyMetadata(@PathParam(value="symbol") String symbol) {
        CurrencyMetaData metaData = (CurrencyMetaData)this.producerTemplate.requestBody("xchange:kraken?service=metadata&method=currencyMetaData", (Object)Currency.getInstance((String)symbol), CurrencyMetaData.class);
        return metaData.getScale().toString();
    }

    @Path(value="/currency/pairs")
    @GET
    @Produces(value={"application/json"})
    public JsonObject currencyPairs() {
        List currencyPairs = (List)this.producerTemplate.requestBody("xchange:kraken?service=metadata&method=currencyPairs", null, List.class);
        JsonArrayBuilder builder = Json.createArrayBuilder();
        currencyPairs.forEach(cp -> builder.add(cp.toString()));
        return Json.createObjectBuilder().add("currencyPairs", (JsonValue)builder.build()).build();
    }

    @Path(value="/currency/pairs/metadata")
    @GET
    @Produces(value={"text/plain"})
    public String currencyPairsMetadata(@QueryParam(value="base") String base, @QueryParam(value="counter") String counter) {
        CurrencyPairMetaData metaData = (CurrencyPairMetaData)this.producerTemplate.requestBody("xchange:kraken?service=metadata&method=currencyPairMetaData", (Object)new CurrencyPair(base, counter), CurrencyPairMetaData.class);
        return metaData.getTradingFee().toPlainString();
    }
}

