/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xchange.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.xchange.it.XchangeBinanceTestResource;
import org.apache.camel.quarkus.component.xchange.it.XchangeKrakenTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=XchangeBinanceTestResource.class), @QuarkusTestResource(value=XchangeKrakenTestResource.class)})
class XchangeTest {
    XchangeTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"binance", "kraken"})
    public void currencyTicker(String cryptoExchange) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("currencyPair", new Object[]{"BTC/USDT"}).get("/xchange/ticker/" + cryptoExchange, new Object[0])).then()).statusCode(200)).body("last", Matchers.greaterThan((Comparable)Integer.valueOf(0)), new Object[]{"bid", Matchers.greaterThan((Comparable)Integer.valueOf(0)), "ask", Matchers.greaterThan((Comparable)Integer.valueOf(0))});
    }

    @Test
    public void currencies() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/xchange/currency", new Object[0])).then()).statusCode(200)).body("currencies", Matchers.hasItems((Object[])new String[]{"BTC", "ETH"}), new Object[0]);
    }

    @Test
    public void currencyMetadata() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/xchange/currency/metadata/BTC", new Object[0])).then()).statusCode(200)).body(Matchers.not((Matcher)Matchers.emptyOrNullString()), new Matcher[0]);
    }

    @Test
    public void currencyPairs() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/xchange/currency/pairs", new Object[0])).then()).statusCode(200)).body("currencyPairs", Matchers.hasItems((Object[])new String[]{"BTC/USDT", "ETH/USDT"}), new Object[0]);
    }

    @Test
    public void currencyPairMetadata() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("base", new Object[]{"BTC"}).queryParam("counter", new Object[]{"USDT"}).get("/xchange/currency/pairs/metadata", new Object[0])).then()).statusCode(200)).body(Matchers.not((Matcher)Matchers.emptyOrNullString()), new Matcher[0]);
    }
}

