/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xchange.it;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.apache.camel.quarkus.test.wiremock.WireMockTestResourceLifecycleManager;

public abstract class XchangeTestResourceBase
extends WireMockTestResourceLifecycleManager {
    private boolean mockingEnabled = true;

    XchangeTestResourceBase() {
        if (!MockBackendUtils.startMockBackend((boolean)false)) {
            LOG.infof("Checking the status of the %s API", (Object)this.getCryptoExchangeName());
            if (this.isCryptoApiAccessible()) {
                LOG.infof("Real backend will be used for %s", (Object)this.getCryptoExchangeName());
                this.mockingEnabled = false;
            } else {
                LOG.warnf("Falling back to mock backend for %s as %s is not accessible", (Object)this.getCryptoExchangeName(), (Object)this.getRecordTargetBaseUrl());
            }
        }
    }

    public Map<String, String> start() {
        Map options = super.start();
        String wireMockUrl = (String)options.get("wiremock.url");
        if (wireMockUrl != null) {
            options.put(this.getWireMockUrlProperty(), wireMockUrl);
        }
        return options;
    }

    protected boolean isMockingEnabled() {
        return this.mockingEnabled;
    }

    String getWireMockUrlProperty() {
        return String.format("wiremock.%s.url", this.getCryptoExchangeName());
    }

    boolean isCryptoApiAccessible() {
        try {
            JsonPath body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)this.getHealthEndpointUrl(), (Object[])new Object[0]).then()).statusCode(200)).extract().body().jsonPath();
            String status = body.getString(this.getHealthStatusField());
            LOG.infof("Status of the %s API is %s", (Object)this.getCryptoExchangeName(), (Object)status);
            return status != null && status.equals(this.getExpectedHealthStatus());
        }
        catch (Exception e) {
            LOG.warnf((Throwable)e, "Failed to contact the %s API", (Object)this.getCryptoExchangeName());
            return false;
        }
    }

    abstract String getCryptoExchangeName();

    abstract String getHealthEndpointUrl();

    abstract String getHealthStatusField();

    abstract String getExpectedHealthStatus();
}

