/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.vertx.kafka.it;

import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecords;
import io.vertx.kafka.client.producer.KafkaProducer;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Path(value="/vertx-kafka")
public class VertxKafkaResource {
    @Inject
    KafkaConsumer<String, String> kafkaConsumer;
    @Inject
    KafkaProducer<String, String> kafkaProducer;

    @Path(value="/get")
    @GET
    @Produces(value={"text/plain"})
    public String get() throws Exception {
        CompletableFuture result = new CompletableFuture();
        this.kafkaConsumer.poll(Duration.ofSeconds(10L), asyncResult -> {
            if (asyncResult.succeeded()) {
                KafkaConsumerRecords consumerRecords = (KafkaConsumerRecords)asyncResult.result();
                ConsumerRecord record = (ConsumerRecord)consumerRecords.records().iterator().next();
                result.complete((String)record.value());
            } else {
                result.completeExceptionally(asyncResult.cause());
            }
        });
        return (String)result.get(15L, TimeUnit.SECONDS);
    }

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    public Response post(String message) throws Exception {
        KafkaProducerRecord record = KafkaProducerRecord.create((String)"inbound", (Object)message);
        this.kafkaProducer.send(record);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

