/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.vertx.kafka.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class VertxKafkaTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String KAFKA_IMAGE_NAME = "confluentinc/cp-kafka:5.4.3";
    private KafkaContainer container;

    public Map<String, String> start() {
        try {
            DockerImageName imageName = DockerImageName.parse((String)KAFKA_IMAGE_NAME);
            this.container = (KafkaContainer)new KafkaContainer(imageName).withEmbeddedZookeeper().waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return Collections.singletonMap("camel.component.vertx-kafka.bootstrap-servers", this.container.getBootstrapServers());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

