/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.vertx.kafka.it;

import io.vertx.core.Vertx;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.kafka.client.producer.KafkaProducer;
import java.util.HashMap;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class VertxKafkaProducers {
    public static final String GROUP_ID = "camel-quarkus-group";
    public static final String TOPIC_INBOUND = "inbound";
    public static final String TOPIC_OUTBOUND = "outbound";

    @Produces
    @Singleton
    public KafkaConsumer<String, String> createKafkaConsumer(Vertx vertx) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("auto.commit.interval.ms", "1000");
        config.put("auto.offset.reset", "earliest");
        config.put("bootstrap.servers", System.getProperty("camel.component.vertx-kafka.bootstrap-servers"));
        config.put("enable.auto.commit", "true");
        config.put("group.id", GROUP_ID);
        config.put("key.deserializer", StringDeserializer.class.getName());
        config.put("session.timeout.ms", "30000");
        config.put("value.deserializer", StringDeserializer.class.getName());
        KafkaConsumer consumer = KafkaConsumer.create((Vertx)vertx, config);
        return consumer.subscribe(TOPIC_OUTBOUND);
    }

    @Produces
    @Singleton
    public KafkaProducer<String, String> createKafkaProducer(Vertx vertx) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("acks", "1");
        config.put("bootstrap.servers", System.getProperty("camel.component.vertx-kafka.bootstrap-servers"));
        config.put("key.serializer", StringSerializer.class.getName());
        config.put("partitioner.class", DefaultPartitioner.class.getName());
        config.put("value.serializer", StringSerializer.class.getName());
        return KafkaProducer.create((Vertx)vertx, config);
    }
}

