/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.velocity.it;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.velocity.it.Person;
import org.jboss.logging.Logger;

@Path(value="/velocity")
@ApplicationScoped
public class VelocityResource {
    private static final Logger LOG = Logger.getLogger(VelocityResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    private String endpointUri;

    @Path(value="/template")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response template(final String message, final @QueryParam(value="item") String item, final @QueryParam(value="name") String name, @QueryParam(value="template") String template, @QueryParam(value="propertiesFile") String propertiesFile, @QueryParam(value="contentCache") String contentCache, @QueryParam(value="expectFailure") String exectFaiure) throws Exception {
        LOG.infof("Sending to velocity: %s", (Object)message);
        HashMap headers = new HashMap(){
            {
                if (item != null) {
                    this.put("item", item);
                }
                if (name != null) {
                    this.put("name", name);
                }
                this.put("CamelVelocityTemplate", message);
            }
        };
        String endpointUrl = "velocity:" + template;
        if (propertiesFile != null) {
            endpointUrl = endpointUrl + "?propertiesFile=" + propertiesFile;
        }
        if (contentCache != null) {
            endpointUrl = endpointUrl + "?contentCache=" + contentCache;
        }
        try {
            String response = (String)this.producerTemplate.requestBodyAndHeaders(endpointUrl, (Object)message, (Map)headers, String.class);
            LOG.infof("Got response from velocity: %s", (Object)response);
            return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
        }
        catch (Exception e) {
            if (exectFaiure != null && Boolean.parseBoolean(exectFaiure)) {
                return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)e.toString()).status(500).build();
            }
            throw e;
        }
    }

    @Path(value="/bodyAsDomainObject")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response bodyAsDomainObject(Person person, @QueryParam(value="givenName") String givenName, @QueryParam(value="familyName") String familyName) throws Exception {
        LOG.infof("Sending to velocity: %s", (Object)person);
        String response = (String)this.producerTemplate.requestBody("velocity://template/BodyAsDomainObject.vm", (Object)person, String.class);
        LOG.infof("Got response from velocity: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/templateViaHeader")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response templateViaHeader(final String message, @QueryParam(value="body") String body, final @QueryParam(value="item") String item, final @QueryParam(value="name") String name) throws Exception {
        LOG.infof("Sending to velocity: %s", (Object)body);
        HashMap headers = new HashMap(){
            {
                this.put("item", item);
                this.put("name", name);
                this.put("CamelVelocityTemplate", message);
            }
        };
        String response = (String)this.producerTemplate.requestBodyAndHeaders("velocity::dummy?allowTemplateFromHeader=true", (Object)body, (Map)headers, String.class);
        LOG.infof("Got response from velocity: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/withProperties")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response withProperties(String message, @QueryParam(value="item") String item, @QueryParam(value="name") String name) throws Exception {
        LOG.infof("Sending to velocity: %s", (Object)message);
        Exchange response = this.producerTemplate.request("velocity::dummy?allowTemplateFromHeader=true&allowContextMapAll=true", exchange -> {
            exchange.getIn().setHeader("CamelVelocityTemplate", (Object)message);
            exchange.setProperty("name", (Object)name);
            exchange.setProperty("item", (Object)item);
        });
        LOG.infof("Got response from velocity: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(response.getMessage().getBody()).build();
    }

    @Path(value="/supplementalContext")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response supplementalContext(final String message, @QueryParam(value="body") String body, @QueryParam(value="supplementalBody") String supplementalBody) throws Exception {
        LOG.infof("Sending to velocity: %s", (Object)body);
        final HashMap<String, String> supplementalContext = new HashMap<String, String>();
        supplementalContext.put("body", supplementalBody);
        HashMap headers = new HashMap(){
            {
                this.put("CamelVelocityTemplate", message);
                this.put("CamelVelocitySupplementalContext", supplementalContext);
            }
        };
        Exchange result = this.producerTemplate.request("velocity::dummy?allowTemplateFromHeader=true", exchange -> {
            exchange.getMessage().setHeaders(headers);
            exchange.getMessage().setBody((Object)body);
        });
        LOG.infof("Got response from velocity: %s", (Object)result);
        Map<String, String> resultMap = result.getMessage().getHeaders().entrySet().stream().filter(e -> e.getValue() instanceof String).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        resultMap.put("result_value", (String)result.getMessage().getBody(String.class));
        return Response.status((Response.Status)Response.Status.OK).entity(resultMap).build();
    }
}

