/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.velocity.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.camel.quarkus.component.velocity.it.Person;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class VelocityTest {
    public static final String OLD_BODY = "old_body";
    public static final String BODY = "bar";
    public static final String NEW_BODY = "new_body";
    public static final String MSG = "\nDear Sheldon\n\nThanks for the order of Camel in Action.\n\nRegards Apache Camel Riders Bookstore\nPS: Next beer is on me";

    VelocityTest() {
    }

    @Test
    public void testTemplateViaFile() throws IOException {
        File template = this.createFile("velocity_test", "Hi ${headers.name}. You have got ${headers.item}. ${body}");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"Sheldon"}).queryParam("item", new Object[]{"Camel in Action"}).queryParam("template", new Object[]{"file:/" + template.getPath()}).contentType(ContentType.TEXT).body("PS: Next beer is on me").post("/velocity/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)"Hi Sheldon. You have got Camel in Action. PS: Next beer is on me"), new Matcher[0]);
    }

    @Test
    public void testTemplateViaClasspath() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"Sheldon"}).queryParam("item", new Object[]{"Camel in Action"}).queryParam("template", new Object[]{"//template/letter.vm"}).contentType(ContentType.TEXT).body("PS: Next beer is on me").post("/velocity/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)MSG), new Matcher[0]);
    }

    @Test
    public void testTemplateViaClasspathWithProperties() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"Sheldon"}).queryParam("item", new Object[]{"Camel in Action"}).queryParam("template", new Object[]{"//template/template.vm"}).queryParam("propertiesFile", new Object[]{"/template/velocity.properties"}).queryParam("expectFailure", new Object[]{"true"}).contentType(ContentType.TEXT).body("PS: Next beer is on me").post("/velocity/template", new Object[0])).then()).statusCode(500)).body(CoreMatchers.containsString((String)"Exception"), new Matcher[0]);
    }

    @Test
    public void testTemplateViaHeader() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("body", new Object[]{"PS: Next beer is on me."}).queryParam("name", new Object[]{"Sheldon"}).queryParam("item", new Object[]{"Camel in Action"}).contentType(ContentType.TEXT).body("Hi ${headers.name}. Thanks for ${headers.item}. ${body}").post("/velocity/templateViaHeader", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)"Hi Sheldon. Thanks for Camel in Action. PS: Next beer is on me."), new Matcher[0]);
    }

    @Test
    public void testSupplementalContext() {
        String template = "#set( $headers.body = ${body} )\nbar";
        Map result = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("body", new Object[]{OLD_BODY}).queryParam("supplementalBody", new Object[]{NEW_BODY}).contentType(ContentType.TEXT).body("#set( $headers.body = ${body} )\nbar").post("/velocity/supplementalContext", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertTrue((boolean)result.containsKey("result_value"));
        Assertions.assertEquals((Object)BODY, result.get("result_value"));
        Assertions.assertTrue((boolean)result.containsKey("body"));
        Assertions.assertEquals((Object)NEW_BODY, result.get("body"));
    }

    @Test
    public void testBodyAsDomainObject() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"Sheldon"}).queryParam("country", new Object[]{"Earth 1"}).contentType(ContentType.JSON).body((Object)new Person("Sheldon", "Earth 2")).post("/velocity/bodyAsDomainObject", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)"\nHi Sheldon from Earth 2"), new Matcher[0]);
    }

    @Test
    public void testContentCacheFalse() throws Exception {
        this.testContentCache(false);
    }

    @Test
    public void testContentCacheTrue() throws Exception {
        this.testContentCache(true);
    }

    private void testContentCache(boolean useContentCache) throws Exception {
        File template = this.createFile("velocity_test", "Hi ${body}");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("template", new Object[]{"file:/" + template.getPath()}).queryParam("contentCache", new Object[]{useContentCache}).contentType(ContentType.TEXT).body("Sheldon").post("/velocity/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)"Hi Sheldon"), new Matcher[0]);
        Files.write(Paths.get(template.getPath(), new String[0]), "Bye ${body}".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("template", new Object[]{"file:/" + template.getPath()}).queryParam("contentCache", new Object[]{useContentCache}).contentType(ContentType.TEXT).body("Sheldon").post("/velocity/template", new Object[0])).then()).statusCode(201)).body(CoreMatchers.equalTo((Object)(useContentCache ? "Hi Sheldon" : "Bye Sheldon")), new Matcher[0]);
    }

    private File createFile(String fileName, String body) throws IOException {
        File tmpFile = File.createTempFile(fileName, ".vm");
        Files.write(tmpFile.toPath(), body.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        tmpFile.deleteOnExit();
        return tmpFile;
    }
}

