/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.validator.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.validator.it.ValidatorTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=ValidatorTestResource.class)
class ValidatorTest {
    ValidatorTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath", "filesystem", "http"})
    public void validXML(String scheme) {
        String requestBody = "<message><firstName>MyFirstname</firstName><lastName>MyLastname</lastName></message>";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(requestBody).post("/validator/validate/" + scheme, new Object[0])).then()).statusCode(200)).assertThat()).body(Matchers.containsString((String)"MyFirstname"), new Matcher[0])).and()).body(Matchers.containsString((String)"MyLastname"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"classpath", "filesystem", "http"})
    public void inValidXML(String scheme) {
        String requestBody = "<message><firstName>MyFirstname</firstName></message>";
        String errorResponse = "Exception occurred during execution on the exchange";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(requestBody).post("/validator/validate/" + scheme, new Object[0])).then()).statusCode(500)).assertThat()).body(Matchers.containsString((String)errorResponse), new Matcher[0]);
    }
}

