/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.twitter;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;
import twitter4j.Status;

@Path(value="/twitter")
@ApplicationScoped
public class CamelResource {
    private static final Logger LOG = Logger.getLogger(CamelResource.class);
    @ConfigProperty(name="twitter.user.name")
    String twitterUserName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/timeline")
    @GET
    @Produces(value={"text/plain"})
    public String getTimeline(@QueryParam(value="sinceId") String sinceId) {
        String tweets = (String)this.consumerTemplate.receiveBodyNoWait(String.format("twitter-timeline://home?sinceId=%s&count=1", sinceId), String.class);
        LOG.infof("Received tweets from user's timeline: %s", (Object)tweets);
        return tweets;
    }

    @Path(value="/timeline")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response postTweet(String message) throws Exception {
        Status s = (Status)this.producerTemplate.requestBody("twitter-timeline://user", (Object)message, Status.class);
        LOG.infof("Posted a tweet %s", (Object)s.getText());
        return Response.created((URI)new URI(String.format("https://twitter.com/%s/status/%d", URLEncoder.encode(s.getUser().getName(), StandardCharsets.UTF_8.toString()), s.getId()))).header("messageId", (Object)s.getId()).entity((Object)s.getText()).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"text/plain"})
    public String search(@QueryParam(value="keywords") String keywords) {
        LOG.infof("Searching for keywords on twitter: %s", (Object)keywords);
        String tweets = (String)this.consumerTemplate.receiveBodyNoWait("twitter-search://" + keywords + "?count=1", String.class);
        LOG.infof("Received tweets from twitter search: %s", (Object)tweets);
        return tweets;
    }

    @Path(value="/directmessage")
    @GET
    @Produces(value={"text/plain"})
    public String getDirectmessages() {
        LOG.infof("Polling direct messages of user '%s'", (Object)this.twitterUserName);
        String result = (String)this.consumerTemplate.receiveBodyNoWait(String.format("twitter-directmessage://%s?count=16&type=polling&delay=3000&sortById=false", this.twitterUserName), String.class);
        LOG.infof("Received direct messages: %s", (Object)result);
        return result;
    }

    @Path(value="/directmessage")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response postDirectmessage(String message) throws Exception {
        LOG.infof("Sending direct message to user '%s': %s", (Object)this.twitterUserName, (Object)message);
        this.producerTemplate.requestBody(String.format("twitter-directmessage:%s", this.twitterUserName), (Object)message);
        LOG.infof("Sent direct message to user '%s': %s", (Object)this.twitterUserName, (Object)message);
        return Response.created((URI)new URI("https://twitter.com/")).build();
    }
}

