/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.twitter;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

@QuarkusTest
@EnabledIfEnvironmentVariable(named="TWITTER_CONSUMER_KEY", matches="[a-zA-Z0-9]+")
public class CamelTwitterTest {
    @Test
    public void direct() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String msg = String.format("Direct message from camel-quarkus-twitter %s", uuid);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/twitter/directmessage", new Object[0])).then()).statusCode(201);
        int retries = 5;
        int delayMs = 3000;
        String body = null;
        boolean passed = false;
        for (int i = 0; i < 5; ++i) {
            body = RestAssured.get((String)"/twitter/directmessage", (Object[])new Object[0]).asString();
            if (body.contains("camel-quarkus-twitter")) {
                passed = true;
                break;
            }
            if (i + 1 >= 5) continue;
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!passed) {
            Assertions.fail((String)("Could not find a message containing 'camel-quarkus-twitter' in user's direct messages within ~15000 ms; got messages: " + body));
        }
    }

    @Test
    public void e2e() {
        int i;
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String msg = String.format("Hello from camel-quarkus-twitter %s", uuid);
        String expectedMessage = ") " + msg;
        String messageId = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/twitter/timeline", new Object[0])).then()).statusCode(201)).body(StringContains.containsString((String)msg), new Matcher[0])).extract().header("messageId");
        long sinceId = Long.parseLong(messageId) - 1L;
        int retries = 5;
        int delayMs = 3000;
        String body = null;
        boolean passed = false;
        for (i = 0; i < 5; ++i) {
            body = ((Response)RestAssured.given().param("sinceId", new Object[]{sinceId}).get("/twitter/timeline", new Object[0])).asString();
            if (body.contains(expectedMessage)) {
                passed = true;
                break;
            }
            if (i + 1 >= 5) continue;
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!passed) {
            Assertions.fail((String)("Could not find the expected message '" + expectedMessage + "' in user's timeline within ~" + 15000 + " ms; got messages: " + body));
        }
        retries = 4;
        delayMs = 10000;
        body = null;
        passed = false;
        for (i = 0; i < 4; ++i) {
            body = ((Response)RestAssured.given().param("keywords", new Object[]{"camel-quarkus-twitter"}).get("/twitter/search", new Object[0])).asString();
            if (body.contains("camel-quarkus-twitter")) {
                passed = true;
                break;
            }
            if (i + 1 >= 4) continue;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!passed) {
            Assertions.fail((String)("Could not find the expected message '" + uuid + "' via twitter-search within " + 40000 + " ms; got messages: " + body));
        }
    }
}

