/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.twilio.it;

import com.twilio.http.HttpClient;
import com.twilio.http.NetworkHttpClient;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.rest.api.v2010.account.IncomingPhoneNumber;
import com.twilio.rest.api.v2010.account.Message;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.ConfigProvider;

@Path(value="/twilio")
public class TwilioResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/message")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public jakarta.ws.rs.core.Response createMessage(String body) throws Exception {
        Message message = (Message)this.producerTemplate.requestBody("twilio://message/create?from=RAW(+15005550006)&to=RAW(+14108675310)&body=" + body, null, Message.class);
        return jakarta.ws.rs.core.Response.ok((Object)message.getSid()).build();
    }

    @Path(value="/purchase")
    @POST
    @Produces(value={"text/plain"})
    public jakarta.ws.rs.core.Response purchasePhoneNumber() throws Exception {
        IncomingPhoneNumber phoneNumber = (IncomingPhoneNumber)this.producerTemplate.requestBody("twilio://incoming-phone-number/create?phonenumber=RAW(+15005550006)", null, IncomingPhoneNumber.class);
        return jakarta.ws.rs.core.Response.ok((Object)phoneNumber.getPhoneNumber()).build();
    }

    @Path(value="/call")
    @POST
    @Produces(value={"text/plain"})
    public jakarta.ws.rs.core.Response phoneCall() throws Exception {
        Call call = (Call)this.producerTemplate.requestBody("twilio://call/create?from=RAW(+15005550006)&to=RAW(+14108675310)&url=http://demo.twilio.com/docs/voice.xml", null, Call.class);
        return jakarta.ws.rs.core.Response.ok((Object)call.getSid()).build();
    }

    @Named(value="restClient")
    public TwilioRestClient restClient() {
        final Optional wireMockUrl = ConfigProvider.getConfig().getOptionalValue("wiremock.url", String.class);
        if (wireMockUrl.isPresent()) {
            NetworkHttpClient client = new NetworkHttpClient(){

                public Response makeRequest(Request originalRequest) {
                    String url = originalRequest.getUrl();
                    Request modified = new Request(originalRequest.getMethod(), url.replace("https://api.twilio.com", (CharSequence)wireMockUrl.get()));
                    Map headerParams = originalRequest.getHeaderParams();
                    for (Object key : headerParams.keySet()) {
                        for (Object value : (List)headerParams.get(key)) {
                            modified.addHeaderParam((String)key, (String)value);
                        }
                    }
                    Map postParams = originalRequest.getPostParams();
                    for (String key : postParams.keySet()) {
                        for (String value : (List)postParams.get(key)) {
                            modified.addPostParam(key, value);
                        }
                    }
                    Map queryParams = originalRequest.getQueryParams();
                    for (String key : queryParams.keySet()) {
                        for (String value : (List)queryParams.get(key)) {
                            modified.addQueryParam(key, value);
                        }
                    }
                    modified.setAuth(originalRequest.getUsername(), originalRequest.getPassword());
                    return super.makeRequest(modified);
                }
            };
            return new TwilioRestClient.Builder((String)ConfigProvider.getConfig().getValue("camel.component.twilio.username", String.class), (String)ConfigProvider.getConfig().getValue("camel.component.twilio.password", String.class)).accountSid((String)ConfigProvider.getConfig().getValue("camel.component.twilio.account-sid", String.class)).httpClient((HttpClient)client).build();
        }
        return null;
    }
}

