/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.timer.it;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class TimerProducers {
    private static final Logger LOG = Logger.getLogger(TimerProducers.class);
    public static final String LOG_MESSAGE = "Lets's fool io.quarkus.test.common.LauncherUtil.CaptureListeningDataReader: Listening on: http://0.0.0.0:";
    @ConfigProperty(name="quarkus.http.test-port")
    Optional<Integer> httpTestPort;
    @ConfigProperty(name="quarkus.http.port")
    Optional<Integer> httpPort;

    private int getEffectivePort() {
        boolean isNativeMode = "executable".equals(System.getProperty("org.graalvm.nativeimage.kind"));
        Optional<Integer> portSource = isNativeMode ? this.httpPort : this.httpTestPort;
        return portSource.isPresent() ? portSource.get() : 0;
    }

    @Produces
    public LambdaRouteBuilder lambdaRoute() {
        return rb -> rb.from("timer:bar?repeatCount=1").routeId("bar").process(e -> LOG.info((Object)(LOG_MESSAGE + this.getEffectivePort())));
    }
}

