/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.it;

import java.util.Map;
import org.apache.camel.quarkus.test.wiremock.WireMockTestResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;

public class TelegramTestResource
extends WireMockTestResourceLifecycleManager {
    private static final String TELEGRAM_API_BASE_URL = "https://api.telegram.org";
    private static final String TELEGRAM_ENV_AUTHORIZATION_TOKEN = "TELEGRAM_AUTHORIZATION_TOKEN";
    private static final String TELEGRAM_ENV_CHAT_ID = "TELEGRAM_CHAT_ID";
    private static final String TELEGRAM_ENV_WEBHOOK_EXTERNAL_URL = "TELEGRAM_WEBHOOK_EXTERNAL_URL";
    private static final String TELEGRAM_ENV_WEBHOOK_AUTHORIZATION_TOKEN = "TELEGRAM_WEBHOOK_AUTHORIZATION_TOKEN";

    public Map<String, String> start() {
        Map properties = super.start();
        String wireMockUrl = (String)properties.get("wiremock.url");
        String baseUri = wireMockUrl != null ? wireMockUrl : TELEGRAM_API_BASE_URL;
        return CollectionHelper.mergeMaps((Map)properties, (Map[])new Map[]{CollectionHelper.mapOf((Object)"camel.component.telegram.base-uri", (Object)baseUri, (Object[])new Object[0])});
    }

    protected String getRecordTargetBaseUrl() {
        return TELEGRAM_API_BASE_URL;
    }

    protected boolean isMockingEnabled() {
        return !this.envVarsPresent(new String[]{TELEGRAM_ENV_AUTHORIZATION_TOKEN, TELEGRAM_ENV_CHAT_ID, TELEGRAM_ENV_WEBHOOK_EXTERNAL_URL, TELEGRAM_ENV_WEBHOOK_AUTHORIZATION_TOKEN});
    }
}

