/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.it;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.telegram.model.EditMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.MessageResult;
import org.apache.camel.component.telegram.model.SendLocationMessage;
import org.apache.camel.component.telegram.model.SendVenueMessage;
import org.apache.camel.component.telegram.model.StopMessageLiveLocationMessage;
import org.apache.camel.quarkus.component.telegram.it.TelegramTestResource;
import org.apache.camel.quarkus.test.TrustStoreResource;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=TrustStoreResource.class), @QuarkusTestResource(value=TelegramTestResource.class)})
public class TelegramTest {
    private static final Logger LOG = Logger.getLogger(TelegramTest.class);
    @MockServer
    WireMockServer server;

    @Test
    public void postText() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String msg = "A message from camel-quarkus-telegram" + (String)(System.getenv("TELEGRAM_AUTHORIZATION_TOKEN") != null ? " " + uuid : "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/telegram/messages", new Object[0])).then()).statusCode(201);
    }

    @Test
    public void getText() {
        if (this.server != null) {
            this.server.stubFor(WireMock.request((String)"GET", (UrlPattern)WireMock.urlPathMatching((String)"/.*/getUpdates")).withQueryParam("limit", WireMock.equalTo((String)"100")).withQueryParam("timeout", WireMock.equalTo((String)"30")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{\"ok\":true,\"result\":[{\"update_id\":123488937,\n\"message\":{\"message_id\":37,\"from\":{\"id\":1426416050,\"is_bot\":false,\"first_name\":\"Apache\",\"last_name\":\"Camel\",\"language_code\":\"en\"},\"chat\":{\"id\":1426416050,\"first_name\":\"Apache\",\"last_name\":\"Camel\",\"type\":\"private\"},\"date\":1604406332,\"text\":\"test\"}}]}")));
        }
        for (int i = 0; i < 5; ++i) {
            String body = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/telegram/messages", (Object[])new Object[0]).then()).statusCode(Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(200))).and(Matchers.lessThan((Comparable)Integer.valueOf(300)))))).extract().body().asString();
            LOG.info((Object)("Telegram Bot received messages: " + body));
        }
    }

    @Test
    public void png() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("camel-quarkus-rocks.png");){
            ((ValidatableResponse)((Response)RestAssured.given().contentType("image/png").body(in).post("/telegram/media", new Object[0])).then()).statusCode(201);
        }
    }

    @Test
    public void mp3() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("camel-quarkus-rocks.mp3");){
            ((ValidatableResponse)((Response)RestAssured.given().contentType("audio/mpeg").body(in).post("/telegram/media", new Object[0])).then()).statusCode(201);
        }
    }

    @Test
    public void mp4() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("camel-quarkus-rocks.mp4");){
            ((ValidatableResponse)((Response)RestAssured.given().contentType("video/mp4").body(in).post("/telegram/media", new Object[0])).then()).statusCode(201);
        }
    }

    @Test
    public void pdf() throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("camel-quarkus-rocks.pdf");){
            ((ValidatableResponse)((Response)RestAssured.given().contentType("application/pdf").body(in).post("/telegram/media", new Object[0])).then()).statusCode(201);
        }
    }

    @Test
    public void location() throws IOException {
        SendLocationMessage sendLoc = new SendLocationMessage(29.974834, 31.138577);
        sendLoc.setLivePeriod(Integer.valueOf(120));
        MessageResult result = (MessageResult)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)sendLoc).post("/telegram/send-location", new Object[0])).then()).statusCode(201)).extract().body().as(MessageResult.class);
        EditMessageLiveLocationMessage edit = new EditMessageLiveLocationMessage(29.974928, 31.131115);
        edit.setChatId(result.getMessage().getChat().getId());
        edit.setMessageId(result.getMessage().getMessageId());
        Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).pollInterval(100L, TimeUnit.MILLISECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
            int code = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)edit).post("/telegram/edit-location", new Object[0])).then()).extract().statusCode();
            return code == 201;
        });
        StopMessageLiveLocationMessage stop = new StopMessageLiveLocationMessage();
        stop.setChatId(result.getMessage().getChat().getId());
        stop.setMessageId(result.getMessage().getMessageId());
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)stop).post("/telegram/stop-location", new Object[0])).then()).statusCode(201);
    }

    @Test
    public void venue() throws IOException {
        SendVenueMessage venue = new SendVenueMessage(29.977818, 31.136329, "Pyramid of Queen Henutsen", "El-Hussein Ibn Ali Ln, Nazlet El-Semman, Al Haram, Giza Governorate, Egypt");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)venue).post("/telegram/venue", new Object[0])).then()).statusCode(201);
    }
}

