/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.it;

import java.net.URI;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.telegram.TelegramMediaType;
import org.apache.camel.component.telegram.model.EditMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.InlineKeyboardButton;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.ReplyKeyboardMarkup;
import org.apache.camel.component.telegram.model.ReplyMarkup;
import org.apache.camel.component.telegram.model.SendLocationMessage;
import org.apache.camel.component.telegram.model.SendVenueMessage;
import org.apache.camel.component.telegram.model.StopMessageLiveLocationMessage;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/telegram")
@ApplicationScoped
public class TelegramResource {
    private static final Logger log = Logger.getLogger(TelegramResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="telegram.chatId")
    String chatId;

    @Path(value="/messages")
    @GET
    @Produces(value={"text/plain"})
    public String getMessages() {
        String messages = (String)this.consumerTemplate.receiveBody("telegram://bots", 5000L, String.class);
        log.infof("Received telegram messages: %s", (Object)messages);
        return messages;
    }

    @Path(value="/messages")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response postMessage(String msg) throws Exception {
        OutgoingTextMessage message = new OutgoingTextMessage();
        message.setText(msg);
        InlineKeyboardButton buttonOptionOneI = InlineKeyboardButton.builder().text("Option One - I").build();
        InlineKeyboardButton buttonOptionOneII = InlineKeyboardButton.builder().text("Option One - II").build();
        InlineKeyboardButton buttonOptionTwoI = InlineKeyboardButton.builder().text("Option Two - I").build();
        ReplyKeyboardMarkup replyMarkup = ReplyKeyboardMarkup.builder().keyboard().addRow(Arrays.asList(buttonOptionOneI, buttonOptionOneII)).addRow(Arrays.asList(buttonOptionTwoI)).close().oneTimeKeyboard(Boolean.valueOf(true)).build();
        message.setReplyMarkup((ReplyMarkup)replyMarkup);
        this.producerTemplate.requestBody(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message);
        log.infof("Sent a message to telegram %s", (Object)msg);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).build();
    }

    @Path(value="/media")
    @POST
    @Produces(value={"text/plain"})
    public Response postMedia(@HeaderParam(value="Content-type") String type, byte[] message) throws Exception {
        TelegramMediaType telegramMediaType;
        if (type != null && type.startsWith("image/")) {
            telegramMediaType = TelegramMediaType.PHOTO_PNG;
        } else if (type != null && type.startsWith("audio/")) {
            telegramMediaType = TelegramMediaType.AUDIO;
        } else if (type != null && type.startsWith("video/")) {
            telegramMediaType = TelegramMediaType.VIDEO;
        } else if (type != null && type.startsWith("application/pdf")) {
            telegramMediaType = TelegramMediaType.DOCUMENT;
        } else {
            return Response.status((int)415, (String)("Unsupported content type " + type)).build();
        }
        this.producerTemplate.requestBodyAndHeader(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message, "CamelTelegramMediaType", (Object)telegramMediaType);
        log.infof("Sent a message to telegram %s", (Object)message);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).build();
    }

    @Path(value="/send-location")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response sendLocation(SendLocationMessage message) throws Exception {
        Object result = this.producerTemplate.requestBody(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message);
        log.infof("Sent a message to telegram %s", (Object)message);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).entity(result).build();
    }

    @Path(value="/edit-location")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response editLocation(EditMessageLiveLocationMessage message) throws Exception {
        this.producerTemplate.requestBody(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message);
        log.infof("Sent a message to telegram %s", (Object)message);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).build();
    }

    @Path(value="/stop-location")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response stopLocation(StopMessageLiveLocationMessage message) throws Exception {
        this.producerTemplate.requestBody(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message);
        log.infof("Sent a message to telegram %s", (Object)message);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).build();
    }

    @Path(value="/venue")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response venue(SendVenueMessage message) throws Exception {
        Object result = this.producerTemplate.requestBody(String.format("telegram://bots?chatId=%s", this.chatId), (Object)message);
        log.infof("Sent a message to telegram %s", (Object)message);
        return Response.created((URI)new URI(String.format("https://telegram.org/", new Object[0]))).entity(result).build();
    }
}

