/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.it;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public class TelegramRoutes
extends RouteBuilder {
    public void configure() throws Exception {
        this.from("platform-http:/bot{authToken}/getUpdates?httpMethodRestrict=GET").process(e -> TelegramRoutes.load("mock-messages/getUpdates.json", e));
        Stream.of("sendMessage", "sendAudio", "sendVideo", "sendDocument", "sendPhoto", "sendVenue", "sendLocation", "stopMessageLiveLocation").forEach(endpoint -> this.from("platform-http:/{authToken}/" + endpoint + "?httpMethodRestrict=POST").process(e -> TelegramRoutes.load("mock-messages/" + endpoint + ".json", e)));
    }

    private static void load(String path, Exchange exchange) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
             InputStream in = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)exchange.getContext(), (String)path);){
            IOHelper.copy((InputStream)in, (OutputStream)out, (int)4096);
            byte[] bytes = out.toByteArray();
            exchange.getMessage().setBody((Object)bytes);
            exchange.getMessage().setHeader("Content-Length", (Object)bytes.length);
            exchange.getMessage().setHeader("Content-Type", (Object)"application/json; charset=UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

