/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.telegram.it;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.IOHelper;

public class TelegramRoutes
extends RouteBuilder {
    public void configure() throws Exception {
        this.from("platform-http:/bot{authToken}/getUpdates?httpMethodRestrict=GET").process((Processor)new ResourceSupplier("mock-messages/getUpdates.json"));
        Arrays.asList("sendMessage", "sendAudio", "sendVideo", "sendDocument", "sendPhoto", "sendVenue", "sendLocation", "stopMessageLiveLocation").stream().forEach(endpoint -> this.from("platform-http:/{authToken}/" + endpoint + "?httpMethodRestrict=POST").process((Processor)new ResourceSupplier("mock-messages/" + endpoint + ".json")));
    }

    static class ResourceSupplier
    implements Processor {
        private final byte[] bytes;

        public ResourceSupplier(String path) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                 InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);){
                IOHelper.copy((InputStream)in, (OutputStream)out, (int)4096);
                this.bytes = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void process(Exchange exchange) throws Exception {
            Message m = exchange.getMessage();
            m.setBody((Object)this.bytes);
            m.setHeader("Content-Length", (Object)this.bytes.length);
            m.setHeader("Content-Type", (Object)"application/json; charset=UTF-8");
        }
    }
}

