/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.tarfile.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/tarfile")
@ApplicationScoped
public class TarfileResource {
    private static final Logger LOG = Logger.getLogger(TarfileResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/octet-stream"})
    public Response post(String message) throws Exception {
        LOG.infof("Sending to tarfile: %s", (Object)message);
        byte[] response = (byte[])this.producerTemplate.requestBody("direct:start", (Object)message, byte[].class);
        LOG.infof("Got response from tarfile: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).header("content-length", (Object)response.length).entity((Object)response).build();
    }
}

