/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.tarfile.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/tarfile")
@ApplicationScoped
public class TarfileResource {
    private static final Logger LOG = Logger.getLogger(TarfileResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/post")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"application/octet-stream"})
    public Response post(String message) throws Exception {
        LOG.infof("Sending to tarfile: %s", (Object)message);
        byte[] response = (byte[])this.producerTemplate.requestBody("direct:start", (Object)message, byte[].class);
        LOG.infof("Got response from tarfile: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).header("content-length", (Object)response.length).entity((Object)response).build();
    }
}

