/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.tarfile.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class TarfileTest {
    TarfileTest() {
    }

    @Test
    public void test() throws Exception {
        String encoding = "utf-8";
        ExtractableResponse response = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT + "; charset=" + "utf-8").body("Hello World").post("/tarfile/post", new Object[0])).then()).extract();
        byte[] body = response.body().asByteArray();
        Assertions.assertNotNull((Object)body);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(body);
        TarArchiveInputStream tis = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)bis);
        TarArchiveEntry entry = tis.getNextTarEntry();
        if (entry != null) {
            IOHelper.copy((InputStream)tis, (OutputStream)bos);
        }
        String str = bos.toString("utf-8");
        Assertions.assertEquals((Object)"Hello World", (Object)str);
    }
}

