/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.syslog.it;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.component.syslog.netty.Rfc5425Encoder;
import org.apache.camel.component.syslog.netty.Rfc5425FrameDecoder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/syslog")
public class SyslogResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="camel.netty.rfc5425.port")
    int syslogRfc5425ServerPort;
    @ConfigProperty(name="camel.netty.rfc3164.port")
    int syslogRfc3164ServerPort;

    @Path(value="/send/{version}")
    @POST
    @Consumes(value={"text/plain"})
    public Response sendMessage(@PathParam(value="version") String version, String message) throws Exception {
        int port = version.equals("rfc5425") ? this.syslogRfc5425ServerPort : this.syslogRfc3164ServerPort;
        this.producerTemplate.sendBody("netty:udp://127.0.0.1:" + port + "?sync=false&allowDefaultCodec=false&useByteBuf=true", (Object)message.getBytes(StandardCharsets.UTF_8));
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/messages")
    @GET
    @Produces(value={"application/json"})
    public Response getSyslogMessage() {
        SyslogMessage syslogMessage = (SyslogMessage)this.consumerTemplate.receiveBody("seda:syslog-unmarshalled", 10000L, SyslogMessage.class);
        HashMap<String, Object> syslogInfo = new HashMap<String, Object>();
        syslogInfo.put("hostname", syslogMessage.getHostname());
        syslogInfo.put("logMessage", syslogMessage.getLogMessage());
        syslogInfo.put("timestamp", syslogMessage.getTimestamp());
        return Response.ok(syslogInfo).build();
    }

    @Path(value="/messages/raw")
    @GET
    @Produces(value={"text/plain"})
    public String getRawMessage() {
        return (String)this.consumerTemplate.receiveBody("seda:syslog-marshalled", 10000L, String.class);
    }

    @jakarta.enterprise.inject.Produces
    @Named
    public Rfc5425Encoder rfc5425Encoder() {
        return new Rfc5425Encoder();
    }

    @jakarta.enterprise.inject.Produces
    @Named
    public Rfc5425FrameDecoder rfc5425FrameDecoder() {
        return new Rfc5425FrameDecoder();
    }
}

