/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.camel.quarkus.test.TrustStoreResource;

public class ExtendDefaultTrustStore {
    public static Path extendTrustStoreIfNeeded(Path extendedTrustStorePath, String[] certs) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Path sslDir = extendedTrustStorePath.getParent();
        if (Files.exists(extendedTrustStorePath, new LinkOption[0])) {
            System.out.println("Nothing to do, the trust store exists already: " + extendedTrustStorePath);
        } else {
            Path defaultTrustStore = TrustStoreResource.getDefaultTrustStorePath();
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream in = Files.newInputStream(defaultTrustStore, new OpenOption[0]);){
                keystore.load(in, null);
            }
            System.out.println("Loaded " + defaultTrustStore);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (String cert : certs) {
                System.out.println("Adding " + cert);
                int colonPos = cert.indexOf(58);
                String alias = colonPos >= 0 ? cert.substring(0, colonPos) : "localhost";
                String certPath = colonPos >= 0 ? cert.substring(colonPos + 1) : cert;
                try (BufferedInputStream in = new BufferedInputStream(ExtendDefaultTrustStore.class.getClassLoader().getResourceAsStream(certPath));){
                    X509Certificate ca = (X509Certificate)cf.generateCertificate(in);
                    keystore.setCertificateEntry(alias, ca);
                }
            }
            Files.createDirectories(sslDir, new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(extendedTrustStorePath, new OpenOption[0]);){
                keystore.store(out, new char[0]);
            }
            System.out.println("Stored the extended trust store to " + extendedTrustStorePath);
        }
        return extendedTrustStorePath;
    }

    public static void main(String[] args) {
        try {
            Path baseDir = Paths.get(args[0], new String[0]);
            String[] certs = new String[args.length - 1];
            System.arraycopy(args, 1, certs, 0, args.length - 1);
            ExtendDefaultTrustStore.extendTrustStoreIfNeeded(baseDir, certs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extend the default trust store with args " + String.join((CharSequence)", ", args), e);
        }
    }
}

