/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.util.Optional;
import org.apache.camel.quarkus.test.EnabledIfProperty;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledIfPropertyCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledIfProperty is not present");

    EnabledIfPropertyCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledIfProperty.class).map(this::map).orElse(ENABLED_BY_DEFAULT);
    }

    private ConditionEvaluationResult map(EnabledIfProperty annotation) {
        String name = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank((String)name, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank((String)regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        return ConfigProviderResolver.instance().getConfig().getOptionalValue(name, String.class).map((? super T actual) -> actual.matches(regex) ? ConditionEvaluationResult.enabled((String)String.format("Config property [%s] with value [%s] matches regular expression [%s]", name, actual, regex)) : ConditionEvaluationResult.disabled((String)String.format("Config property [%s] with value [%s] does not match regular expression [%s]", name, actual, regex))).orElseGet(() -> ConditionEvaluationResult.disabled((String)String.format("Config property [%s] does not exist", name)));
    }
}

