/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailablePortFinder.class);
    private static final Map<Integer, String> RESERVED_PORTS = new ConcurrentHashMap<Integer, String>();
    private static final String[] QUARKUS_PORT_PROPERTIES = new String[]{"quarkus.http.test-port", "quarkus.http.test-ssl-port", "quarkus.https.test-port"};

    private AvailablePortFinder() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNextAvailable() {
        AvailablePortFinder.logWarningIfNativeApplication();
        try {
            while (true) {
                ServerSocket ss = new ServerSocket();
                try {
                    ss.setReuseAddress(true);
                    ss.bind(new InetSocketAddress((InetAddress)null, 0), 1);
                    int port = ss.getLocalPort();
                    if (AvailablePortFinder.isQuarkusReservedPort(port)) continue;
                    String callerClassName = AvailablePortFinder.getCallerClassName();
                    String value = RESERVED_PORTS.putIfAbsent(port, callerClassName);
                    if (value != null) continue;
                    LOGGER.info("{} reserved port {}", (Object)callerClassName, (Object)port);
                    int n = port;
                    return n;
                }
                finally {
                    ss.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find free port", e);
        }
    }

    public static Map<String, Integer> reserveNetworkPorts(String ... names) {
        return AvailablePortFinder.reserveNetworkPorts(Function.identity(), names);
    }

    public static <T> Map<String, T> reserveNetworkPorts(Function<Integer, T> converter, String ... names) {
        HashMap<String, T> reservedPorts = new HashMap<String, T>();
        for (String name : names) {
            reservedPorts.put(name, converter.apply(AvailablePortFinder.getNextAvailable()));
        }
        return reservedPorts;
    }

    public static void releaseReservedPorts() {
        String callerClassName = AvailablePortFinder.getCallerClassName();
        RESERVED_PORTS.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(callerClassName)).peek(entry -> LOGGER.info("Releasing port {} reserved by {}", entry.getKey(), entry.getValue())).map(Map.Entry::getKey).forEach(RESERVED_PORTS::remove);
    }

    private static boolean isQuarkusReservedPort(int port) {
        Config config = ConfigProvider.getConfig();
        for (String property : QUARKUS_PORT_PROPERTIES) {
            Optional portProperty = config.getOptionalValue(property, Integer.class);
            if (!portProperty.isPresent() || port != (Integer)portProperty.get()) continue;
            LOGGER.info("Port {} is already reserved for {}", (Object)port, (Object)property);
            return true;
        }
        return false;
    }

    private static String getCallerClassName() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.map(StackWalker.StackFrame::getClassName).filter(className -> !className.equals(AvailablePortFinder.class.getName())).findFirst().orElseThrow(IllegalStateException::new));
    }

    private static void logWarningIfNativeApplication() {
        if (System.getProperty("org.graalvm.nativeimage.kind") != null) {
            LOGGER.warn("Usage of AvailablePortFinder in the native application is discouraged. Pass the reserved port to the native application under test with QuarkusTestResource or via an HTTP request");
        }
    }
}

