/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.mock.backend;

import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class MockBackendUtils {
    private static final Logger LOG = Logger.getLogger(MockBackendUtils.class);

    public static void logBackendUsed() {
        if (MockBackendUtils.mockBackendStarted()) {
            MockBackendUtils.logMockBackendUsed();
        } else {
            MockBackendUtils.logRealBackendUsed();
        }
    }

    public static void logRealBackendUsed() {
        LOG.infof("Real backend will be used", new Object[0]);
    }

    public static void logMockBackendUsed() {
        LOG.infof("Mock backend will be used", new Object[0]);
    }

    public static boolean startMockBackend() {
        return MockBackendUtils.startMockBackend(false);
    }

    public static boolean startMockBackend(boolean printLogMessage) {
        if (printLogMessage) {
            MockBackendUtils.logBackendUsed();
        }
        return MockBackendUtils.mockBackendStarted();
    }

    static boolean mockBackendStarted() {
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MockBackendUtils.class.getClassLoader());
            boolean bl = ConfigProvider.getConfig().getOptionalValue("camel.quarkus.start-mock-backend", Boolean.class).orElse(Boolean.TRUE);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTCCL);
        }
    }
}

